/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import org.ibex.nestedvm.Runtime;
import org.ibex.nestedvm.util.InodeCache;
import org.ibex.nestedvm.util.Platform;
import org.ibex.nestedvm.util.Seekable;
import org.ibex.nestedvm.util.Sort;

public abstract class UnixRuntime
extends Runtime
implements Cloneable {
    private int pid;
    private UnixRuntime parent;
    private static final GlobalState defaultGS;
    private GlobalState gs;
    private String cwd;
    private UnixRuntime execedRuntime;
    private Object children;
    private Vector activeChildren;
    private Vector exitedChildren;
    private static final Method runtimeCompilerCompile;
    static /* synthetic */ Class class$org$ibex$nestedvm$util$Seekable;
    static /* synthetic */ Class class$java$lang$String;

    public final int getPid() {
        return this.pid;
    }

    public void setGlobalState(GlobalState globalState) {
        if (this.state != 1) {
            throw new IllegalStateException("can't change GlobalState when running");
        }
        if (globalState == null) {
            throw new NullPointerException("gs is null");
        }
        this.gs = globalState;
    }

    protected UnixRuntime(int n, int n2) {
        this(n, n2, false);
    }

    protected UnixRuntime(int n, int n2, boolean bl) {
        super(n, n2, bl);
        if (!bl) {
            this.gs = defaultGS;
            String string = Platform.getProperty("user.dir");
            String string2 = this.cwd = string == null ? null : this.gs.mapHostPath(string);
            if (this.cwd == null) {
                this.cwd = "/";
            }
            this.cwd = this.cwd.substring(1);
        }
    }

    private static String posixTZ() {
        StringBuffer stringBuffer = new StringBuffer();
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset() / 1000;
        stringBuffer.append(Platform.timeZoneGetDisplayName(timeZone, false, false));
        if (n > 0) {
            stringBuffer.append("-");
        } else {
            n = -n;
        }
        stringBuffer.append(n / 3600);
        if ((n %= 3600) > 0) {
            stringBuffer.append(":").append(n / 60);
        }
        if ((n %= 60) > 0) {
            stringBuffer.append(":").append(n);
        }
        if (timeZone.useDaylightTime()) {
            stringBuffer.append(Platform.timeZoneGetDisplayName(timeZone, true, false));
        }
        return stringBuffer.toString();
    }

    private static boolean envHas(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].startsWith(string + "=")) continue;
            return true;
        }
        return false;
    }

    String[] createEnv(String[] stringArray) {
        int n;
        String string;
        String[] stringArray2 = new String[7];
        int n2 = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (!UnixRuntime.envHas("USER", stringArray) && Platform.getProperty("user.name") != null) {
            stringArray2[n2++] = "USER=" + Platform.getProperty("user.name");
        }
        if (!UnixRuntime.envHas("HOME", stringArray) && (string = Platform.getProperty("user.home")) != null && (string = this.gs.mapHostPath(string)) != null) {
            stringArray2[n2++] = "HOME=" + string;
        }
        if (!UnixRuntime.envHas("TMPDIR", stringArray) && (string = Platform.getProperty("java.io.tmpdir")) != null && (string = this.gs.mapHostPath(string)) != null) {
            stringArray2[n2++] = "TMPDIR=" + string;
        }
        if (!UnixRuntime.envHas("SHELL", stringArray)) {
            stringArray2[n2++] = "SHELL=/bin/sh";
        }
        if (!UnixRuntime.envHas("TERM", stringArray) && !win32Hacks) {
            stringArray2[n2++] = "TERM=vt100";
        }
        if (!UnixRuntime.envHas("TZ", stringArray)) {
            stringArray2[n2++] = "TZ=" + UnixRuntime.posixTZ();
        }
        if (!UnixRuntime.envHas("PATH", stringArray)) {
            stringArray2[n2++] = "PATH=/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin";
        }
        String[] stringArray3 = new String[stringArray.length + n2];
        for (n = 0; n < n2; ++n) {
            stringArray3[n] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n2++] = stringArray[n];
        }
        return stringArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _started() {
        UnixRuntime[] unixRuntimeArray = this.gs.tasks;
        GlobalState globalState = this.gs;
        synchronized (globalState) {
            if (this.pid != 0) {
                UnixRuntime unixRuntime = unixRuntimeArray[this.pid];
                if (unixRuntime == null || unixRuntime == this || unixRuntime.pid != this.pid || unixRuntime.parent != this.parent) {
                    throw new Error("should never happen");
                }
                Object object = this.parent.children;
                synchronized (object) {
                    int n = this.parent.activeChildren.indexOf(unixRuntime);
                    if (n == -1) {
                        throw new Error("should never happen");
                    }
                    this.parent.activeChildren.setElementAt(this, n);
                }
            } else {
                int n;
                int n2;
                int n3 = -1;
                for (n2 = n = this.gs.nextPID; n2 < unixRuntimeArray.length; ++n2) {
                    if (unixRuntimeArray[n2] != null) continue;
                    n3 = n2;
                    break;
                }
                if (n3 == -1) {
                    for (n2 = 1; n2 < n; ++n2) {
                        if (unixRuntimeArray[n2] != null) continue;
                        n3 = n2;
                        break;
                    }
                }
                if (n3 == -1) {
                    throw new ProcessTableFullExn();
                }
                this.pid = n3;
                this.gs.nextPID = n3 + 1;
            }
            unixRuntimeArray[this.pid] = this;
        }
    }

    int _syscall(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws Runtime.ErrnoException, Runtime.FaultException {
        switch (n) {
            case 11: {
                return this.sys_kill(n2, n3);
            }
            case 25: {
                return this.sys_fork();
            }
            case 23: {
                return this.sys_pipe(n2);
            }
            case 24: {
                return this.sys_dup2(n2, n3);
            }
            case 39: {
                return this.sys_dup(n2);
            }
            case 26: {
                return this.sys_waitpid(n2, n3, n4);
            }
            case 14: {
                return this.sys_stat(n2, n3);
            }
            case 33: {
                return this.sys_lstat(n2, n3);
            }
            case 18: {
                return this.sys_mkdir(n2, n3);
            }
            case 27: {
                return this.sys_getcwd(n2, n3);
            }
            case 22: {
                return this.sys_chdir(n2);
            }
            case 28: {
                return this.sys_exec(n2, n3, n4);
            }
            case 36: {
                return this.sys_getdents(n2, n3, n4, n5);
            }
            case 20: {
                return this.sys_unlink(n2);
            }
            case 46: {
                return this.sys_getppid();
            }
            case 56: {
                return this.sys_socket(n2, n3, n4);
            }
            case 57: {
                return this.sys_connect(n2, n3, n4);
            }
            case 58: {
                return this.sys_resolve_hostname(n2, n3, n4);
            }
            case 60: {
                return this.sys_setsockopt(n2, n3, n4, n5, n6);
            }
            case 61: {
                return this.sys_getsockopt(n2, n3, n4, n5, n6);
            }
            case 63: {
                return this.sys_bind(n2, n3, n4);
            }
            case 62: {
                return this.sys_listen(n2, n3);
            }
            case 59: {
                return this.sys_accept(n2, n3, n4);
            }
            case 64: {
                return this.sys_shutdown(n2, n3);
            }
            case 53: {
                return this.sys_sysctl(n2, n3, n4, n5, n6, n7);
            }
            case 65: {
                return this.sys_sendto(n2, n3, n4, n5, n6, n7);
            }
            case 66: {
                return this.sys_recvfrom(n2, n3, n4, n5, n6, n7);
            }
            case 67: {
                return this.sys_select(n2, n3, n4, n5, n6);
            }
            case 78: {
                return this.sys_access(n2, n3);
            }
            case 52: {
                return this.sys_realpath(n2, n3);
            }
            case 76: {
                return this.sys_chown(n2, n3, n4);
            }
            case 43: {
                return this.sys_chown(n2, n3, n4);
            }
            case 77: {
                return this.sys_fchown(n2, n3, n4);
            }
            case 74: {
                return this.sys_chmod(n2, n3, n4);
            }
            case 75: {
                return this.sys_fchmod(n2, n3, n4);
            }
            case 29: {
                return this.sys_fcntl_lock(n2, n3, n4);
            }
            case 73: {
                return this.sys_umask(n2);
            }
        }
        return super._syscall(n, n2, n3, n4, n5, n6, n7);
    }

    Runtime.FD _open(String string, int n, int n2) throws Runtime.ErrnoException {
        return this.gs.open(this, this.normalizePath(string), n, n2);
    }

    private int sys_getppid() {
        return this.parent == null ? 1 : this.parent.pid;
    }

    private int sys_chown(int n, int n2, int n3) {
        return 0;
    }

    private int sys_lchown(int n, int n2, int n3) {
        return 0;
    }

    private int sys_fchown(int n, int n2, int n3) {
        return 0;
    }

    private int sys_chmod(int n, int n2, int n3) {
        return 0;
    }

    private int sys_fchmod(int n, int n2, int n3) {
        return 0;
    }

    private int sys_umask(int n) {
        return 0;
    }

    private int sys_access(int n, int n2) throws Runtime.ErrnoException, Runtime.ReadFaultException {
        return this.gs.stat(this, this.cstring(n)) == null ? -2 : 0;
    }

    private int sys_realpath(int n, int n2) throws Runtime.FaultException {
        String string = this.normalizePath(this.cstring(n));
        byte[] byArray = UnixRuntime.getNullTerminatedBytes(string);
        if (byArray.length > 1024) {
            return -34;
        }
        this.copyout(byArray, n2, byArray.length);
        return 0;
    }

    private int sys_kill(int n, int n2) {
        if (n != n) {
            return -3;
        }
        if (n2 < 0 || n2 >= 32) {
            return -22;
        }
        switch (n2) {
            case 0: {
                return 0;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: {
                break;
            }
            default: {
                this.exit(128 + n2, true);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sys_waitpid(int n, int n2, int n3) throws Runtime.FaultException, Runtime.ErrnoException {
        boolean bl;
        if ((n3 & 0xFFFFFFFE) != 0) {
            return -22;
        }
        if (n == 0 || n < -1) {
            System.err.println("WARNING: waitpid called with a pid of " + n);
            return -10;
        }
        boolean bl2 = bl = (n3 & 1) == 0;
        if (n != -1 && (n <= 0 || n >= this.gs.tasks.length)) {
            return -10;
        }
        if (this.children == null) {
            return bl ? -10 : 0;
        }
        UnixRuntime unixRuntime = null;
        Object object = this.children;
        synchronized (object) {
            while (true) {
                if (n == -1) {
                    if (this.exitedChildren.size() > 0) {
                        unixRuntime = (UnixRuntime)this.exitedChildren.elementAt(this.exitedChildren.size() - 1);
                        this.exitedChildren.removeElementAt(this.exitedChildren.size() - 1);
                    }
                } else if (n > 0) {
                    if (n >= this.gs.tasks.length) {
                        return -10;
                    }
                    UnixRuntime unixRuntime2 = this.gs.tasks[n];
                    if (unixRuntime2.parent != this) {
                        return -10;
                    }
                    if (unixRuntime2.state == 4) {
                        if (!this.exitedChildren.removeElement(unixRuntime2)) {
                            throw new Error("should never happen");
                        }
                        unixRuntime = unixRuntime2;
                    }
                } else {
                    throw new Error("should never happen");
                }
                if (unixRuntime != null) break;
                if (!bl) {
                    return 0;
                }
                try {
                    this.children.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.gs.tasks[unixRuntime.pid] = null;
        }
        if (n2 != 0) {
            this.memWrite(n2, unixRuntime.exitStatus() << 8);
        }
        return unixRuntime.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _exited() {
        Enumeration enumeration;
        Object object;
        if (this.children != null) {
            object = this.children;
            synchronized (object) {
                UnixRuntime unixRuntime;
                enumeration = this.exitedChildren.elements();
                while (enumeration.hasMoreElements()) {
                    unixRuntime = (UnixRuntime)enumeration.nextElement();
                    this.gs.tasks[unixRuntime.pid] = null;
                }
                this.exitedChildren.removeAllElements();
                enumeration = this.activeChildren.elements();
                while (enumeration.hasMoreElements()) {
                    unixRuntime = (UnixRuntime)enumeration.nextElement();
                    unixRuntime.parent = null;
                }
                this.activeChildren.removeAllElements();
            }
        }
        if ((object = this.parent) == null) {
            this.gs.tasks[this.pid] = null;
        } else {
            enumeration = ((UnixRuntime)object).children;
            synchronized (enumeration) {
                if (this.parent == null) {
                    this.gs.tasks[this.pid] = null;
                } else {
                    if (!this.parent.activeChildren.removeElement(this)) {
                        throw new Error("should never happen _exited: pid: " + this.pid);
                    }
                    this.parent.exitedChildren.addElement(this);
                    this.parent.children.notify();
                }
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        UnixRuntime unixRuntime = (UnixRuntime)super.clone();
        unixRuntime.pid = 0;
        unixRuntime.parent = null;
        unixRuntime.children = null;
        unixRuntime.exitedChildren = null;
        unixRuntime.activeChildren = null;
        return unixRuntime;
    }

    private int sys_fork() {
        UnixRuntime unixRuntime;
        try {
            unixRuntime = (UnixRuntime)this.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -12;
        }
        unixRuntime.parent = this;
        try {
            unixRuntime._started();
        }
        catch (ProcessTableFullExn processTableFullExn) {
            return -12;
        }
        if (this.children == null) {
            this.children = new Object();
            this.activeChildren = new Vector();
            this.exitedChildren = new Vector();
        }
        this.activeChildren.addElement(unixRuntime);
        Runtime.CPUState cPUState = new Runtime.CPUState();
        this.getCPUState(cPUState);
        cPUState.r[2] = 0;
        cPUState.pc += 4;
        unixRuntime.setCPUState(cPUState);
        unixRuntime.state = 2;
        new ForkedProcess(unixRuntime);
        return unixRuntime.pid;
    }

    public static int runAndExec(UnixRuntime unixRuntime, String string, String[] stringArray) {
        return UnixRuntime.runAndExec(unixRuntime, UnixRuntime.concatArgv(string, stringArray));
    }

    public static int runAndExec(UnixRuntime unixRuntime, String[] stringArray) {
        unixRuntime.start(stringArray);
        return UnixRuntime.executeAndExec(unixRuntime);
    }

    public static int executeAndExec(UnixRuntime unixRuntime) {
        while (true) {
            if (!unixRuntime.execute()) {
                System.err.println("WARNING: Pause requested while executing runAndExec()");
                continue;
            }
            if (unixRuntime.state != 5) {
                return unixRuntime.exitStatus();
            }
            unixRuntime = unixRuntime.execedRuntime;
        }
    }

    private String[] readStringArray(int n) throws Runtime.ReadFaultException {
        int n2 = 0;
        int n3 = n;
        while (this.memRead(n3) != 0) {
            ++n2;
            n3 += 4;
        }
        String[] stringArray = new String[n2];
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            stringArray[n4] = this.cstring(this.memRead(n5));
            ++n4;
            n5 += 4;
        }
        return stringArray;
    }

    private int sys_exec(int n, int n2, int n3) throws Runtime.ErrnoException, Runtime.FaultException {
        return this.exec(this.normalizePath(this.cstring(n)), this.readStringArray(n2), this.readStringArray(n3));
    }

    public Class runtimeCompile(Seekable seekable, String string) throws IOException {
        if (runtimeCompilerCompile == null) {
            System.err.println("WARNING: Exec attempted but RuntimeCompiler not found!");
            return null;
        }
        try {
            return (Class)runtimeCompilerCompile.invoke(null, seekable, "unixruntime,maxinsnpermethod=256,lessconstants", string);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exec(String string, String[] stringArray, String[] stringArray2) throws Runtime.ErrnoException {
        Runtime.FD fD;
        if (stringArray.length == 0) {
            stringArray = new String[]{""};
        }
        if (string.equals("bin/busybox") && this.getClass().getName().endsWith("BusyBox")) {
            return this.execClass(this.getClass(), stringArray, stringArray2);
        }
        Runtime.FStat fStat = this.gs.stat(this, string);
        if (fStat == null) {
            return -2;
        }
        GlobalState.CacheEnt cacheEnt = (GlobalState.CacheEnt)this.gs.execCache.get(string);
        long l = fStat.mtime();
        long l2 = fStat.size();
        if (cacheEnt != null) {
            if (cacheEnt.time == l && cacheEnt.size == l2) {
                if (cacheEnt.o instanceof Class) {
                    return this.execClass((Class)cacheEnt.o, stringArray, stringArray2);
                }
                if (cacheEnt.o instanceof String[]) {
                    return this.execScript(string, (String[])cacheEnt.o, stringArray, stringArray2);
                }
                throw new Error("should never happen");
            }
            this.gs.execCache.remove(string);
        }
        if ((fD = this.gs.open(this, string, 0, 0)) == null) {
            throw new Runtime.ErrnoException(2);
        }
        Seekable seekable = fD.seekable();
        if (seekable == null) {
            throw new Runtime.ErrnoException(13);
        }
        byte[] byArray = new byte[4096];
        try {
            int n = seekable.read(byArray, 0, byArray.length);
            if (n == -1) {
                throw new Runtime.ErrnoException(8);
            }
            switch (byArray[0]) {
                case 127: {
                    if (n < 4) {
                        seekable.tryReadFully(byArray, n, 4 - n);
                    }
                    if (byArray[1] != 69 || byArray[2] != 76 || byArray[3] != 70) {
                        int n2 = -8;
                        return n2;
                    }
                    seekable.seek(0);
                    System.err.println("Running RuntimeCompiler for " + string);
                    Class clazz = this.runtimeCompile(seekable, string);
                    System.err.println("RuntimeCompiler finished for " + string);
                    if (clazz == null) {
                        throw new Runtime.ErrnoException(8);
                    }
                    this.gs.execCache.put(string, new GlobalState.CacheEnt(l, l2, clazz));
                    int n3 = this.execClass(clazz, stringArray, stringArray2);
                    return n3;
                }
                case 35: {
                    int n4;
                    int n5;
                    int n6;
                    if (n == 1) {
                        n6 = seekable.read(byArray, 1, byArray.length - 1);
                        if (n6 == -1) {
                            int n7 = -8;
                            return n7;
                        }
                        n += n6;
                    }
                    if (byArray[1] != 33) {
                        n6 = -8;
                        return n6;
                    }
                    n6 = 2;
                    n -= 2;
                    block14: while (true) {
                        for (n5 = n6; n5 < n6 + n; ++n5) {
                            if (byArray[n5] != 10) continue;
                            n6 = n5;
                            break block14;
                        }
                        if ((n6 += n) == byArray.length) break;
                        n = seekable.read(byArray, n6, byArray.length - n6);
                    }
                    for (n5 = 2; n5 < n6 && byArray[n5] == 32; ++n5) {
                    }
                    if (n5 == n6) {
                        throw new Runtime.ErrnoException(8);
                    }
                    for (n4 = n5; n4 < n6 && byArray[n4] != 32; ++n4) {
                    }
                    int n8 = n4;
                    while (n4 < n6 && byArray[n4] == 32) {
                        ++n4;
                    }
                    String[] stringArray3 = new String[]{new String(byArray, n5, n8 - n5), n4 < n6 ? new String(byArray, n4, n6 - n4) : null};
                    this.gs.execCache.put(string, new GlobalState.CacheEnt(l, l2, stringArray3));
                    int n9 = this.execScript(string, stringArray3, stringArray, stringArray2);
                    return n9;
                }
            }
            int n10 = -8;
            return n10;
        }
        catch (IOException iOException) {
            int n = -5;
            return n;
        }
        finally {
            fD.close();
        }
    }

    public int execScript(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) throws Runtime.ErrnoException {
        int n;
        String[] stringArray4 = new String[stringArray2.length - 1 + (stringArray[1] != null ? 3 : 2)];
        int n2 = stringArray[0].lastIndexOf(47);
        stringArray4[0] = n2 == -1 ? stringArray[0] : stringArray[0].substring(n2 + 1);
        stringArray4[1] = "/" + string;
        n2 = 2;
        if (stringArray[1] != null) {
            stringArray4[n2++] = stringArray[1];
        }
        for (n = 1; n < stringArray2.length; ++n) {
            stringArray4[n2++] = stringArray2[n];
        }
        if (n2 != stringArray4.length) {
            throw new Error("p != newArgv.length");
        }
        System.err.println("Execing: " + stringArray[0]);
        for (n = 0; n < stringArray4.length; ++n) {
            System.err.println("execing [" + n + "] " + stringArray4[n]);
        }
        return this.exec(stringArray[0], stringArray4, stringArray3);
    }

    public int execClass(Class clazz, String[] stringArray, String[] stringArray2) {
        try {
            UnixRuntime unixRuntime = (UnixRuntime)clazz.getDeclaredConstructor(Boolean.TYPE).newInstance(Boolean.TRUE);
            return this.exec(unixRuntime, stringArray, stringArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -8;
        }
    }

    private int exec(UnixRuntime unixRuntime, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < 64; ++i) {
            if (!this.closeOnExec[i]) continue;
            this.closeFD(i);
        }
        unixRuntime.fds = this.fds;
        unixRuntime.closeOnExec = this.closeOnExec;
        this.fds = null;
        this.closeOnExec = null;
        unixRuntime.gs = this.gs;
        unixRuntime.sm = this.sm;
        unixRuntime.cwd = this.cwd;
        unixRuntime.pid = this.pid;
        unixRuntime.parent = this.parent;
        unixRuntime.start(stringArray, stringArray2);
        this.state = 5;
        this.execedRuntime = unixRuntime;
        return 0;
    }

    private int sys_pipe(int n) {
        Pipe pipe = new Pipe();
        int n2 = this.addFD(pipe.reader);
        if (n2 < 0) {
            return -23;
        }
        int n3 = this.addFD(pipe.writer);
        if (n3 < 0) {
            this.closeFD(n2);
            return -23;
        }
        try {
            this.memWrite(n, n2);
            this.memWrite(n + 4, n3);
        }
        catch (Runtime.FaultException faultException) {
            this.closeFD(n2);
            this.closeFD(n3);
            return -14;
        }
        return 0;
    }

    private int sys_dup2(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (n < 0 || n >= 64) {
            return -81;
        }
        if (n2 < 0 || n2 >= 64) {
            return -81;
        }
        if (this.fds[n] == null) {
            return -81;
        }
        if (this.fds[n2] != null) {
            this.fds[n2].close();
        }
        this.fds[n2] = this.fds[n].dup();
        return 0;
    }

    private int sys_dup(int n) {
        if (n < 0 || n >= 64) {
            return -81;
        }
        if (this.fds[n] == null) {
            return -81;
        }
        Runtime.FD fD = this.fds[n].dup();
        int n2 = this.addFD(fD);
        if (n2 < 0) {
            fD.close();
            return -23;
        }
        return n2;
    }

    private int sys_stat(int n, int n2) throws Runtime.FaultException, Runtime.ErrnoException {
        Runtime.FStat fStat = this.gs.stat(this, this.normalizePath(this.cstring(n)));
        if (fStat == null) {
            return -2;
        }
        return this.stat(fStat, n2);
    }

    private int sys_lstat(int n, int n2) throws Runtime.FaultException, Runtime.ErrnoException {
        Runtime.FStat fStat = this.gs.lstat(this, this.normalizePath(this.cstring(n)));
        if (fStat == null) {
            return -2;
        }
        return this.stat(fStat, n2);
    }

    private int sys_mkdir(int n, int n2) throws Runtime.FaultException, Runtime.ErrnoException {
        this.gs.mkdir(this, this.normalizePath(this.cstring(n)), n2);
        return 0;
    }

    private int sys_unlink(int n) throws Runtime.FaultException, Runtime.ErrnoException {
        this.gs.unlink(this, this.normalizePath(this.cstring(n)));
        return 0;
    }

    private int sys_getcwd(int n, int n2) throws Runtime.FaultException, Runtime.ErrnoException {
        byte[] byArray = UnixRuntime.getBytes(this.cwd);
        if (n2 == 0) {
            return -22;
        }
        if (n2 < byArray.length + 2) {
            return -34;
        }
        this.memset(n, 47, 1);
        this.copyout(byArray, n + 1, byArray.length);
        this.memset(n + byArray.length + 1, 0, 1);
        return n;
    }

    private int sys_chdir(int n) throws Runtime.ErrnoException, Runtime.FaultException {
        String string = this.normalizePath(this.cstring(n));
        Runtime.FStat fStat = this.gs.stat(this, string);
        if (fStat == null) {
            return -2;
        }
        if (fStat.type() != 16384) {
            return -20;
        }
        this.cwd = string;
        return 0;
    }

    private int sys_getdents(int n, int n2, int n3, int n4) throws Runtime.FaultException, Runtime.ErrnoException {
        n3 = Math.min(n3, 0xFFFC00);
        if (n < 0 || n >= 64) {
            return -81;
        }
        if (this.fds[n] == null) {
            return -81;
        }
        byte[] byArray = this.byteBuf(n3);
        int n5 = this.fds[n].getdents(byArray, 0, n3);
        this.copyout(byArray, n2, n5);
        return n5;
    }

    void _closedFD(Runtime.FD fD) {
        Seekable seekable = fD.seekable();
        if (seekable == null) {
            return;
        }
        try {
            for (int i = 0; i < this.gs.locks.length; ++i) {
                Seekable.Lock lock = this.gs.locks[i];
                if (lock == null || !seekable.equals(lock.seekable()) || lock.getOwner() != this) continue;
                lock.release();
                this.gs.locks[i] = null;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private int sys_fcntl_lock(int n, int n2, int n3) throws Runtime.FaultException {
        if (n2 != 7 && n2 != 8) {
            return this.sys_fcntl(n, n2, n3);
        }
        if (n < 0 || n >= 64) {
            return -81;
        }
        if (this.fds[n] == null) {
            return -81;
        }
        Runtime.FD fD = this.fds[n];
        if (n3 == 0) {
            return -22;
        }
        int n4 = this.memRead(n3);
        int n5 = this.memRead(n3 + 4);
        int n6 = this.memRead(n3 + 8);
        int n7 = n4 >> 16;
        int n8 = n4 & 0xFF;
        Seekable.Lock[] lockArray = this.gs.locks;
        Seekable seekable = fD.seekable();
        if (seekable == null) {
            return -22;
        }
        try {
            switch (n8) {
                case 0: {
                    break;
                }
                case 1: {
                    n5 += seekable.pos();
                    break;
                }
                case 2: {
                    n5 += seekable.length();
                    break;
                }
                default: {
                    return -1;
                }
            }
            if (n2 == 7) {
                for (int i = 0; i < lockArray.length; ++i) {
                    if (lockArray[i] == null || !seekable.equals(lockArray[i].seekable()) || !lockArray[i].overlaps(n5, n6) || lockArray[i].getOwner() == this || lockArray[i].isShared() && n7 == 1) continue;
                    return 0;
                }
                Seekable.Lock lock = seekable.lock(n5, n6, n7 == 1);
                if (lock != null) {
                    this.memWrite(n3, 196608);
                    lock.release();
                }
                return 0;
            }
            if (n2 != 8) {
                return -22;
            }
            if (n7 == 3) {
                for (int i = 0; i < lockArray.length; ++i) {
                    int n9;
                    if (lockArray[i] == null || !seekable.equals(lockArray[i].seekable()) || lockArray[i].getOwner() != this || (n9 = (int)lockArray[i].position()) < n5 || n5 != 0 && n6 != 0 && (long)n9 + lockArray[i].size() > (long)(n5 + n6)) continue;
                    lockArray[i].release();
                    lockArray[i] = null;
                }
                return 0;
            }
            if (n7 == 1 || n7 == 2) {
                int n10;
                for (int i = 0; i < lockArray.length; ++i) {
                    if (lockArray[i] == null || !seekable.equals(lockArray[i].seekable())) continue;
                    if (lockArray[i].getOwner() == this) {
                        if (lockArray[i].contained(n5, n6)) {
                            lockArray[i].release();
                            lockArray[i] = null;
                            continue;
                        }
                        if (!lockArray[i].contains(n5, n6)) continue;
                        if (lockArray[i].isShared() == (n7 == 1)) {
                            this.memWrite(n3 + 4, (int)lockArray[i].position());
                            this.memWrite(n3 + 8, (int)lockArray[i].size());
                            return 0;
                        }
                        lockArray[i].release();
                        lockArray[i] = null;
                        continue;
                    }
                    if (!lockArray[i].overlaps(n5, n6) || lockArray[i].isShared() && n7 != 2) continue;
                    return -11;
                }
                Seekable.Lock lock = seekable.lock(n5, n6, n7 == 1);
                if (lock == null) {
                    return -11;
                }
                lock.setOwner(this);
                for (n10 = 0; n10 < lockArray.length && lockArray[n10] != null; ++n10) {
                }
                if (n10 == lockArray.length) {
                    return -46;
                }
                lockArray[n10] = lock;
                return 0;
            }
            return -22;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private int sys_socket(int n, int n2, int n3) {
        if (n != 2 || n2 != 1 && n2 != 2) {
            return -123;
        }
        return this.addFD(new SocketFD(n2 == 1 ? 0 : 1));
    }

    private SocketFD getSocketFD(int n) throws Runtime.ErrnoException {
        if (n < 0 || n >= 64) {
            throw new Runtime.ErrnoException(81);
        }
        if (this.fds[n] == null) {
            throw new Runtime.ErrnoException(81);
        }
        if (!(this.fds[n] instanceof SocketFD)) {
            throw new Runtime.ErrnoException(108);
        }
        return (SocketFD)this.fds[n];
    }

    private int sys_connect(int n, int n2, int n3) throws Runtime.ErrnoException, Runtime.FaultException {
        InetAddress inetAddress;
        SocketFD socketFD = this.getSocketFD(n);
        if (socketFD.type() == 0 && (socketFD.s != null || socketFD.ss != null)) {
            return -127;
        }
        int n4 = this.memRead(n2);
        if ((n4 >>> 16 & 0xFF) != 2) {
            return -106;
        }
        int n5 = n4 & 0xFFFF;
        byte[] byArray = new byte[4];
        this.copyin(n2 + 4, byArray, 4);
        try {
            inetAddress = Platform.inetAddressFromBytes(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return -125;
        }
        socketFD.connectAddr = inetAddress;
        socketFD.connectPort = n5;
        try {
            switch (socketFD.type()) {
                case 0: {
                    Socket socket;
                    socketFD.s = socket = new Socket(inetAddress, n5);
                    socketFD.setOptions();
                    socketFD.is = socket.getInputStream();
                    socketFD.os = socket.getOutputStream();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new Error("should never happen");
                }
            }
        }
        catch (IOException iOException) {
            return -111;
        }
        return 0;
    }

    private int sys_resolve_hostname(int n, int n2, int n3) throws Runtime.FaultException {
        InetAddress[] inetAddressArray;
        String string = this.cstring(n);
        int n4 = this.memRead(n3);
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return 1;
        }
        int n5 = UnixRuntime.min(n4 / 4, inetAddressArray.length);
        int n6 = 0;
        while (n6 < n5) {
            byte[] byArray = inetAddressArray[n6].getAddress();
            this.copyout(byArray, n2, 4);
            ++n6;
            n2 += 4;
        }
        this.memWrite(n3, n5 * 4);
        return 0;
    }

    private int sys_setsockopt(int n, int n2, int n3, int n4, int n5) throws Runtime.ReadFaultException, Runtime.ErrnoException {
        SocketFD socketFD = this.getSocketFD(n);
        switch (n2) {
            case 65535: {
                switch (n3) {
                    case 4: 
                    case 8: {
                        if (n5 != 4) {
                            return -22;
                        }
                        int n6 = this.memRead(n4);
                        socketFD.options = n6 != 0 ? (socketFD.options |= n3) : (socketFD.options &= ~n3);
                        socketFD.setOptions();
                        return 0;
                    }
                }
                System.err.println("Unknown setsockopt name passed: " + n3);
                return -109;
            }
        }
        System.err.println("Unknown setsockopt leve passed: " + n2);
        return -109;
    }

    private int sys_getsockopt(int n, int n2, int n3, int n4, int n5) throws Runtime.ErrnoException, Runtime.FaultException {
        SocketFD socketFD = this.getSocketFD(n);
        switch (n2) {
            case 65535: {
                switch (n3) {
                    case 4: 
                    case 8: {
                        int n6 = this.memRead(n5);
                        if (n6 < 4) {
                            return -22;
                        }
                        int n7 = (socketFD.options & n3) != 0 ? 1 : 0;
                        this.memWrite(n4, n7);
                        this.memWrite(n5, 4);
                        return 0;
                    }
                }
                System.err.println("Unknown setsockopt name passed: " + n3);
                return -109;
            }
        }
        System.err.println("Unknown setsockopt leve passed: " + n2);
        return -109;
    }

    private int sys_bind(int n, int n2, int n3) throws Runtime.FaultException, Runtime.ErrnoException {
        SocketFD socketFD = this.getSocketFD(n);
        if (socketFD.type() == 0 && (socketFD.s != null || socketFD.ss != null)) {
            return -127;
        }
        int n4 = this.memRead(n2);
        if ((n4 >>> 16 & 0xFF) != 2) {
            return -106;
        }
        int n5 = n4 & 0xFFFF;
        InetAddress inetAddress = null;
        if (this.memRead(n2 + 4) != 0) {
            byte[] byArray = new byte[4];
            this.copyin(n2 + 4, byArray, 4);
            try {
                inetAddress = Platform.inetAddressFromBytes(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                return -125;
            }
        }
        switch (socketFD.type()) {
            case 0: {
                socketFD.bindAddr = inetAddress;
                socketFD.bindPort = n5;
                return 0;
            }
            case 1: {
                if (socketFD.ds != null) {
                    socketFD.ds.close();
                }
                try {
                    socketFD.ds = inetAddress != null ? new DatagramSocket(n5, inetAddress) : new DatagramSocket(n5);
                }
                catch (IOException iOException) {
                    return -112;
                }
                return 0;
            }
        }
        throw new Error("should never happen");
    }

    private int sys_listen(int n, int n2) throws Runtime.ErrnoException {
        SocketFD socketFD = this.getSocketFD(n);
        if (socketFD.type() != 0) {
            return -95;
        }
        if (socketFD.ss != null || socketFD.s != null) {
            return -127;
        }
        if (socketFD.bindPort < 0) {
            return -95;
        }
        try {
            socketFD.ss = new ServerSocket(socketFD.bindPort, n2, socketFD.bindAddr);
            socketFD.flags |= 2;
            return 0;
        }
        catch (IOException iOException) {
            return -112;
        }
    }

    private int sys_accept(int n, int n2, int n3) throws Runtime.ErrnoException, Runtime.FaultException {
        Object object;
        Socket socket;
        SocketFD socketFD = this.getSocketFD(n);
        if (socketFD.type() != 0) {
            return -95;
        }
        if (!socketFD.listen()) {
            return -95;
        }
        int n4 = this.memRead(n3);
        ServerSocket serverSocket = socketFD.ss;
        try {
            socket = serverSocket.accept();
        }
        catch (IOException iOException) {
            return -5;
        }
        if (n4 >= 8) {
            this.memWrite(n2, 0x6020000 | socket.getPort());
            object = socket.getInetAddress().getAddress();
            this.copyout((byte[])object, n2 + 4, 4);
            this.memWrite(n3, 8);
        }
        object = new SocketFD(0);
        ((SocketFD)object).s = socket;
        try {
            ((SocketFD)object).is = socket.getInputStream();
            ((SocketFD)object).os = socket.getOutputStream();
        }
        catch (IOException iOException) {
            return -5;
        }
        int n5 = this.addFD((Runtime.FD)object);
        if (n5 == -1) {
            ((Runtime.FD)object).close();
            return -23;
        }
        return n5;
    }

    private int sys_shutdown(int n, int n2) throws Runtime.ErrnoException {
        SocketFD socketFD = this.getSocketFD(n);
        if (socketFD.type() != 0 || socketFD.listen()) {
            return -95;
        }
        if (socketFD.s == null) {
            return -128;
        }
        Socket socket = socketFD.s;
        try {
            if (n2 == 0 || n2 == 2) {
                Platform.socketHalfClose(socket, false);
            }
            if (n2 == 1 || n2 == 2) {
                Platform.socketHalfClose(socket, true);
            }
        }
        catch (IOException iOException) {
            return -5;
        }
        return 0;
    }

    private int sys_sendto(int n, int n2, int n3, int n4, int n5, int n6) throws Runtime.ErrnoException, Runtime.ReadFaultException {
        InetAddress inetAddress;
        SocketFD socketFD = this.getSocketFD(n);
        if (n4 != 0) {
            throw new Runtime.ErrnoException(22);
        }
        int n7 = this.memRead(n5);
        if ((n7 >>> 16 & 0xFF) != 2) {
            return -106;
        }
        int n8 = n7 & 0xFFFF;
        byte[] byArray = new byte[4];
        this.copyin(n5 + 4, byArray, 4);
        try {
            inetAddress = Platform.inetAddressFromBytes(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            return -125;
        }
        n3 = Math.min(n3, 0xFFFC00);
        byte[] byArray2 = this.byteBuf(n3);
        this.copyin(n2, byArray2, n3);
        try {
            return socketFD.sendto(byArray2, 0, n3, inetAddress, n8);
        }
        catch (Runtime.ErrnoException errnoException) {
            if (errnoException.errno == 32) {
                this.exit(141, true);
            }
            throw errnoException;
        }
    }

    private int sys_recvfrom(int n, int n2, int n3, int n4, int n5, int n6) throws Runtime.ErrnoException, Runtime.FaultException {
        SocketFD socketFD = this.getSocketFD(n);
        if (n4 != 0) {
            throw new Runtime.ErrnoException(22);
        }
        InetAddress[] inetAddressArray = n5 == 0 ? null : new InetAddress[1];
        int[] nArray = n5 == 0 ? null : new int[1];
        n3 = Math.min(n3, 0xFFFC00);
        byte[] byArray = this.byteBuf(n3);
        int n7 = socketFD.recvfrom(byArray, 0, n3, inetAddressArray, nArray);
        this.copyout(byArray, n2, n7);
        if (n5 != 0) {
            this.memWrite(n5, 0x20000 | nArray[0]);
            byte[] byArray2 = inetAddressArray[0].getAddress();
            this.copyout(byArray2, n5 + 4, 4);
        }
        return n7;
    }

    private int sys_select(int n, int n2, int n3, int n4, int n5) throws Runtime.ReadFaultException, Runtime.ErrnoException {
        return -88;
    }

    private static String hostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "darkstar";
        }
    }

    private int sys_sysctl(int n, int n2, int n3, int n4, int n5, int n6) throws Runtime.FaultException {
        if (n5 != 0) {
            return -1;
        }
        if (n2 == 0) {
            return -2;
        }
        if (n3 == 0) {
            return 0;
        }
        String string = null;
        switch (this.memRead(n)) {
            case 1: {
                if (n2 != 2) break;
                switch (this.memRead(n + 4)) {
                    case 1: {
                        string = "NestedVM";
                        break;
                    }
                    case 10: {
                        string = UnixRuntime.hostName();
                        break;
                    }
                    case 2: {
                        string = "1.0";
                        break;
                    }
                    case 4: {
                        string = "NestedVM Kernel Version 1.0";
                    }
                }
                break;
            }
            case 6: {
                if (n2 != 2) break;
                switch (this.memRead(n + 4)) {
                    case 1: {
                        string = "NestedVM Virtual Machine";
                    }
                }
            }
        }
        if (string == null) {
            return -2;
        }
        int n7 = this.memRead(n4);
        if (string instanceof String) {
            byte[] byArray = UnixRuntime.getNullTerminatedBytes(string);
            if (n7 < byArray.length) {
                return -12;
            }
            n7 = byArray.length;
            this.copyout(byArray, n3, n7);
            this.memWrite(n4, n7);
        } else if (string instanceof Integer) {
            if (n7 < 4) {
                return -12;
            }
            this.memWrite(n3, (Integer)((Object)string));
        } else {
            throw new Error("should never happen");
        }
        return 0;
    }

    private String normalizePath(String string) {
        boolean bl = string.startsWith("/");
        int n = this.cwd.length();
        if (!string.startsWith(".") && string.indexOf("./") == -1 && string.indexOf("//") == -1 && !string.endsWith(".")) {
            return bl ? string.substring(1) : (n == 0 ? string : (string.length() == 0 ? this.cwd : this.cwd + "/" + string));
        }
        char[] cArray = new char[string.length() + 1];
        char[] cArray2 = new char[cArray.length + (bl ? -1 : this.cwd.length())];
        string.getChars(0, string.length(), cArray, 0);
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            while (cArray[++n2] == '/') {
            }
        } else if (n != 0) {
            this.cwd.getChars(0, n, cArray2, 0);
            n3 = n;
        }
        while (cArray[n2] != '\u0000') {
            if (n2 != 0) {
                while (cArray[n2] != '\u0000' && cArray[n2] != '/') {
                    cArray2[n3++] = cArray[n2++];
                }
                if (cArray[n2] == '\u0000') break;
                while (cArray[n2] == '/') {
                    ++n2;
                }
            }
            if (cArray[n2] == '\u0000') break;
            if (cArray[n2] != '.') {
                cArray2[n3++] = 47;
                cArray2[n3++] = cArray[n2++];
                continue;
            }
            if (cArray[n2 + 1] == '\u0000' || cArray[n2 + 1] == '/') {
                ++n2;
                continue;
            }
            if (cArray[n2 + 1] == '.' && (cArray[n2 + 2] == '\u0000' || cArray[n2 + 2] == '/')) {
                n2 += 2;
                if (n3 > 0) {
                    --n3;
                }
                while (n3 > 0 && cArray2[n3] != '/') {
                    --n3;
                }
                continue;
            }
            ++n2;
            cArray2[n3++] = 47;
            cArray2[n3++] = 46;
        }
        if (n3 > 0 && cArray2[n3 - 1] == '/') {
            --n3;
        }
        int n4 = cArray2[0] == '/' ? 1 : 0;
        return new String(cArray2, n4, n3 - n4);
    }

    Runtime.FStat hostFStat(File file, Object object) {
        Object object2;
        boolean bl = false;
        try {
            object2 = new FileInputStream(file);
            switch (((FileInputStream)object2).read()) {
                case 127: {
                    bl = ((FileInputStream)object2).read() == 69 && ((FileInputStream)object2).read() == 76 && ((FileInputStream)object2).read() == 70;
                    break;
                }
                case 35: {
                    bl = ((FileInputStream)object2).read() == 33;
                }
            }
            ((FileInputStream)object2).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = (HostFS)object;
        final short s = ((HostFS)object2).inodes.get(file.getAbsolutePath());
        final int n = ((HostFS)object2).devno;
        return new Runtime.HostFStat(file, bl){

            public int inode() {
                return s;
            }

            public int dev() {
                return n;
            }
        };
    }

    Runtime.FD hostFSDirFD(File file, Object object) {
        HostFS hostFS;
        HostFS hostFS2 = hostFS = (HostFS)object;
        hostFS2.getClass();
        return hostFS2.new HostFS.HostDirFD(file);
    }

    private static void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 >>> 0 & 0xFF);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Method method;
        defaultGS = new GlobalState();
        try {
            method = Class.forName("org.ibex.nestedvm.RuntimeCompiler").getMethod("compile", class$org$ibex$nestedvm$util$Seekable == null ? (class$org$ibex$nestedvm$util$Seekable = UnixRuntime.class$("org.ibex.nestedvm.util.Seekable")) : class$org$ibex$nestedvm$util$Seekable, class$java$lang$String == null ? (class$java$lang$String = UnixRuntime.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UnixRuntime.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            method = null;
        }
        runtimeCompilerCompile = method;
    }

    public static class ResourceFS
    extends FS {
        final InodeCache inodes = new InodeCache(500);

        public Runtime.FStat lstat(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            return this.stat(unixRuntime, string);
        }

        public void mkdir(UnixRuntime unixRuntime, String string, int n) throws Runtime.ErrnoException {
            throw new Runtime.ErrnoException(30);
        }

        public void unlink(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            throw new Runtime.ErrnoException(30);
        }

        Runtime.FStat connFStat(final URLConnection uRLConnection) {
            return new Runtime.FStat(){

                public int type() {
                    return 32768;
                }

                public int nlink() {
                    return 1;
                }

                public int mode() {
                    return 292;
                }

                public int size() {
                    return uRLConnection.getContentLength();
                }

                public int mtime() {
                    return (int)(uRLConnection.getDate() / 1000L);
                }

                public int inode() {
                    return ResourceFS.this.inodes.get(uRLConnection.getURL().toString());
                }

                public int dev() {
                    return ResourceFS.this.devno;
                }
            };
        }

        public Runtime.FStat stat(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            URL uRL = unixRuntime.getClass().getResource("/" + string);
            if (uRL == null) {
                return null;
            }
            try {
                return this.connFStat(uRL.openConnection());
            }
            catch (IOException iOException) {
                throw new Runtime.ErrnoException(5);
            }
        }

        public Runtime.FD open(UnixRuntime unixRuntime, String string, int n, int n2) throws Runtime.ErrnoException {
            if ((n & 0xFFFFFFFC) != 0) {
                System.err.println("WARNING: Unsupported flags passed to ResourceFS.open(\"" + string + "\"): " + Runtime.toHex(n & 0xFFFFFFFC));
                throw new Runtime.ErrnoException(134);
            }
            if ((n & 3) != 0) {
                throw new Runtime.ErrnoException(30);
            }
            URL uRL = unixRuntime.getClass().getResource("/" + string);
            if (uRL == null) {
                return null;
            }
            try {
                final URLConnection uRLConnection = uRL.openConnection();
                Seekable.InputStream inputStream = new Seekable.InputStream(uRLConnection.getInputStream());
                return new Runtime.SeekableFD(inputStream, n){

                    protected Runtime.FStat _fstat() {
                        return ResourceFS.this.connFStat(uRLConnection);
                    }
                };
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (fileNotFoundException.getMessage() != null && fileNotFoundException.getMessage().indexOf("Permission denied") >= 0) {
                    throw new Runtime.ErrnoException(13);
                }
                return null;
            }
            catch (IOException iOException) {
                throw new Runtime.ErrnoException(5);
            }
        }
    }

    public static class DevFS
    extends FS {
        private static final int ROOT_INODE = 1;
        private static final int NULL_INODE = 2;
        private static final int ZERO_INODE = 3;
        private static final int FD_INODE = 4;
        private static final int FD_INODES = 32;
        private Runtime.FD devZeroFD = new Runtime.FD(){

            public int read(byte[] byArray, int n, int n2) {
                for (int i = n; i < n + n2; ++i) {
                    byArray[i] = 0;
                }
                return n2;
            }

            public int write(byte[] byArray, int n, int n2) {
                return n2;
            }

            public int seek(int n, int n2) {
                return 0;
            }

            public Runtime.FStat _fstat() {
                return new DevFStat(){

                    public int inode() {
                        return 3;
                    }
                };
            }

            public int flags() {
                return 2;
            }

            static /* synthetic */ DevFS access$700(1 var0) {
                return var0.DevFS.this;
            }
        };
        private Runtime.FD devNullFD = new Runtime.FD(){

            public int read(byte[] byArray, int n, int n2) {
                return 0;
            }

            public int write(byte[] byArray, int n, int n2) {
                return n2;
            }

            public int seek(int n, int n2) {
                return 0;
            }

            public Runtime.FStat _fstat() {
                return new DevFStat(){

                    public int inode() {
                        return 2;
                    }
                };
            }

            public int flags() {
                return 2;
            }

            static /* synthetic */ DevFS access$800(2 var0) {
                return var0.DevFS.this;
            }
        };

        public Runtime.FD open(UnixRuntime unixRuntime, String string, int n, int n2) throws Runtime.ErrnoException {
            if (string.equals("null")) {
                return this.devNullFD;
            }
            if (string.equals("zero")) {
                return this.devZeroFD;
            }
            if (string.startsWith("fd/")) {
                int n3;
                try {
                    n3 = Integer.parseInt(string.substring(4));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n3 < 0 || n3 >= 64) {
                    return null;
                }
                if (unixRuntime.fds[n3] == null) {
                    return null;
                }
                return unixRuntime.fds[n3].dup();
            }
            if (string.equals("fd")) {
                int n4 = 0;
                for (int i = 0; i < 64; ++i) {
                    if (unixRuntime.fds[i] == null) continue;
                    ++n4;
                }
                final int[] nArray = new int[n4];
                n4 = 0;
                for (int i = 0; i < 64; ++i) {
                    if (unixRuntime.fds[i] == null) continue;
                    nArray[n4++] = i;
                }
                return new DevDirFD(){

                    public int myInode() {
                        return 4;
                    }

                    public int parentInode() {
                        return 1;
                    }

                    public int inode(int n) {
                        return 32 + n;
                    }

                    public String name(int n) {
                        return Integer.toString(nArray[n]);
                    }

                    public int size() {
                        return nArray.length;
                    }
                };
            }
            if (string.equals("")) {
                return new DevDirFD(){

                    public int myInode() {
                        return 1;
                    }

                    public int parentInode() {
                        return 1;
                    }

                    public int inode(int n) {
                        switch (n) {
                            case 0: {
                                return 2;
                            }
                            case 1: {
                                return 3;
                            }
                            case 2: {
                                return 4;
                            }
                        }
                        return -1;
                    }

                    public String name(int n) {
                        switch (n) {
                            case 0: {
                                return "null";
                            }
                            case 1: {
                                return "zero";
                            }
                            case 2: {
                                return "fd";
                            }
                        }
                        return null;
                    }

                    public int size() {
                        return 3;
                    }
                };
            }
            return null;
        }

        public Runtime.FStat stat(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            if (string.equals("null")) {
                return this.devNullFD.fstat();
            }
            if (string.equals("zero")) {
                return this.devZeroFD.fstat();
            }
            if (string.startsWith("fd/")) {
                int n;
                try {
                    n = Integer.parseInt(string.substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n < 0 || n >= 64) {
                    return null;
                }
                if (unixRuntime.fds[n] == null) {
                    return null;
                }
                return unixRuntime.fds[n].fstat();
            }
            if (string.equals("fd")) {
                return new Runtime.FStat(){

                    public int inode() {
                        return 4;
                    }

                    public int dev() {
                        return DevFS.this.devno;
                    }

                    public int type() {
                        return 16384;
                    }

                    public int mode() {
                        return 292;
                    }
                };
            }
            if (string.equals("")) {
                return new Runtime.FStat(){

                    public int inode() {
                        return 1;
                    }

                    public int dev() {
                        return DevFS.this.devno;
                    }

                    public int type() {
                        return 16384;
                    }

                    public int mode() {
                        return 292;
                    }
                };
            }
            return null;
        }

        public void mkdir(UnixRuntime unixRuntime, String string, int n) throws Runtime.ErrnoException {
            throw new Runtime.ErrnoException(30);
        }

        public void unlink(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            throw new Runtime.ErrnoException(30);
        }

        private abstract class DevDirFD
        extends DirFD {
            private DevDirFD() {
            }

            public int myDev() {
                return DevFS.this.devno;
            }
        }

        private abstract class DevFStat
        extends Runtime.FStat {
            private DevFStat() {
            }

            public int dev() {
                return DevFS.this.devno;
            }

            public int mode() {
                return 438;
            }

            public int type() {
                return 8192;
            }

            public int nlink() {
                return 1;
            }

            public abstract int inode();
        }
    }

    public static abstract class DirFD
    extends Runtime.FD {
        private int pos = -2;

        protected abstract int size();

        protected abstract String name(int var1);

        protected abstract int inode(int var1);

        protected abstract int myDev();

        protected abstract int parentInode();

        protected abstract int myInode();

        public int flags() {
            return 0;
        }

        public int getdents(byte[] byArray, int n, int n2) {
            int n3 = n;
            block3: while (n2 > 0 && this.pos < this.size()) {
                block5: {
                    int n4;
                    int n5;
                    switch (this.pos) {
                        case -2: 
                        case -1: {
                            int n6 = n5 = this.pos == -1 ? this.parentInode() : this.myInode();
                            if (n5 != -1) {
                                n4 = 9 + (this.pos == -1 ? 2 : 1);
                                if (n4 > n2) break block3;
                                byArray[n + 8] = 46;
                                if (this.pos != -1) break;
                                byArray[n + 9] = 46;
                                break;
                            }
                            break block5;
                        }
                        default: {
                            String string = this.name(this.pos);
                            byte[] byArray2 = Runtime.getBytes(string);
                            n4 = byArray2.length + 9;
                            if (n4 > n2) break block3;
                            n5 = this.inode(this.pos);
                            System.arraycopy(byArray2, 0, byArray, n + 8, byArray2.length);
                        }
                    }
                    byArray[n + n4 - 1] = 0;
                    n4 = n4 + 3 & 0xFFFFFFFC;
                    UnixRuntime.putInt(byArray, n, n4);
                    UnixRuntime.putInt(byArray, n + 4, n5);
                    n += n4;
                    n2 -= n4;
                }
                ++this.pos;
            }
            return n - n3;
        }

        protected Runtime.FStat _fstat() {
            return new Runtime.FStat(){

                public int type() {
                    return 16384;
                }

                public int inode() {
                    return DirFD.this.myInode();
                }

                public int dev() {
                    return DirFD.this.myDev();
                }
            };
        }
    }

    public static class HostFS
    extends FS {
        InodeCache inodes = new InodeCache(4000);
        protected File root;

        public File getRoot() {
            return this.root;
        }

        private File hostFile(String string) {
            char c = File.separatorChar;
            if (c != '/') {
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    char c2 = cArray[i];
                    if (c2 == '/') {
                        cArray[i] = c;
                        continue;
                    }
                    if (c2 != c) continue;
                    cArray[i] = 47;
                }
                string = new String(cArray);
            }
            return new File(this.root, string);
        }

        public HostFS(String string) {
            this(new File(string));
        }

        public HostFS(File file) {
            this.root = file;
        }

        public Runtime.FD open(UnixRuntime unixRuntime, String string, int n, int n2) throws Runtime.ErrnoException {
            File file = this.hostFile(string);
            return unixRuntime.hostFSOpen(file, n, n2, this);
        }

        public void unlink(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            File file = this.hostFile(string);
            if (unixRuntime.sm != null && !unixRuntime.sm.allowUnlink(file)) {
                throw new Runtime.ErrnoException(1);
            }
            if (!file.exists()) {
                throw new Runtime.ErrnoException(2);
            }
            if (!file.delete()) {
                throw new Runtime.ErrnoException(1);
            }
        }

        public Runtime.FStat stat(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            File file = this.hostFile(string);
            if (unixRuntime.sm != null && !unixRuntime.sm.allowStat(file)) {
                throw new Runtime.ErrnoException(13);
            }
            if (!file.exists()) {
                return null;
            }
            return unixRuntime.hostFStat(file, this);
        }

        public void mkdir(UnixRuntime unixRuntime, String string, int n) throws Runtime.ErrnoException {
            File file = this.hostFile(string);
            if (unixRuntime.sm != null && !unixRuntime.sm.allowWrite(file)) {
                throw new Runtime.ErrnoException(13);
            }
            if (file.exists() && file.isDirectory()) {
                throw new Runtime.ErrnoException(17);
            }
            if (file.exists()) {
                throw new Runtime.ErrnoException(20);
            }
            File file2 = HostFS.getParentFile(file);
            if (!(file2 == null || file2.exists() && file2.isDirectory())) {
                throw new Runtime.ErrnoException(20);
            }
            if (!file.mkdir()) {
                throw new Runtime.ErrnoException(5);
            }
        }

        private static File getParentFile(File file) {
            String string = file.getParent();
            return string == null ? null : new File(string);
        }

        public class HostDirFD
        extends DirFD {
            private final File f;
            private final File[] children;

            public HostDirFD(File file) {
                this.f = file;
                String[] stringArray = file.list();
                this.children = new File[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.children[i] = new File(file, stringArray[i]);
                }
            }

            public int size() {
                return this.children.length;
            }

            public String name(int n) {
                return this.children[n].getName();
            }

            public int inode(int n) {
                return HostFS.this.inodes.get(this.children[n].getAbsolutePath());
            }

            public int parentInode() {
                File file = HostFS.getParentFile(this.f);
                return file == null ? this.myInode() : (int)HostFS.this.inodes.get(file.getAbsolutePath());
            }

            public int myInode() {
                return HostFS.this.inodes.get(this.f.getAbsolutePath());
            }

            public int myDev() {
                return HostFS.this.devno;
            }
        }
    }

    public static abstract class FS {
        static final int OPEN = 1;
        static final int STAT = 2;
        static final int LSTAT = 3;
        static final int MKDIR = 4;
        static final int UNLINK = 5;
        GlobalState owner;
        int devno;

        Object dispatch(int n, UnixRuntime unixRuntime, String string, int n2, int n3) throws Runtime.ErrnoException {
            switch (n) {
                case 1: {
                    return this.open(unixRuntime, string, n2, n3);
                }
                case 2: {
                    return this.stat(unixRuntime, string);
                }
                case 3: {
                    return this.lstat(unixRuntime, string);
                }
                case 4: {
                    this.mkdir(unixRuntime, string, n2);
                    return null;
                }
                case 5: {
                    this.unlink(unixRuntime, string);
                    return null;
                }
            }
            throw new Error("should never happen");
        }

        public Runtime.FStat lstat(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            return this.stat(unixRuntime, string);
        }

        public abstract Runtime.FD open(UnixRuntime var1, String var2, int var3, int var4) throws Runtime.ErrnoException;

        public abstract Runtime.FStat stat(UnixRuntime var1, String var2) throws Runtime.ErrnoException;

        public abstract void mkdir(UnixRuntime var1, String var2, int var3) throws Runtime.ErrnoException;

        public abstract void unlink(UnixRuntime var1, String var2) throws Runtime.ErrnoException;
    }

    public static final class GlobalState {
        Hashtable execCache = new Hashtable();
        final UnixRuntime[] tasks;
        int nextPID = 1;
        Seekable.Lock[] locks = new Seekable.Lock[16];
        private MP[] mps = new MP[0];
        private FS root;

        public GlobalState() {
            this(255);
        }

        public GlobalState(int n) {
            this(n, true);
        }

        public GlobalState(int n, boolean bl) {
            this.tasks = new UnixRuntime[n + 1];
            if (bl) {
                File[] fileArray;
                File file = null;
                if (Platform.getProperty("nestedvm.root") != null) {
                    file = new File(Platform.getProperty("nestedvm.root"));
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("nestedvm.root is not a directory");
                    }
                } else {
                    fileArray = Platform.getProperty("user.dir");
                    file = Platform.getRoot(new File((String)(fileArray != null ? fileArray : ".")));
                }
                this.addMount("/", new HostFS(file));
                if (Platform.getProperty("nestedvm.root") == null) {
                    fileArray = Platform.listRoots();
                    for (int i = 0; i < fileArray.length; ++i) {
                        String string = fileArray[i].getPath();
                        if (string.endsWith(File.separator)) {
                            string = string.substring(0, string.length() - 1);
                        }
                        if (string.length() == 0 || string.indexOf(47) != -1) continue;
                        this.addMount("/" + string.toLowerCase(), new HostFS(fileArray[i]));
                    }
                }
                this.addMount("/dev", new DevFS());
                this.addMount("/resource", new ResourceFS());
            }
        }

        public String mapHostPath(String string) {
            return this.mapHostPath(new File(string));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String mapHostPath(File file) {
            FS fS;
            GlobalState globalState = this;
            synchronized (globalState) {
                this.mps = this.mps;
                fS = this.root;
            }
            if (!file.isAbsolute()) {
                file = new File(file.getAbsolutePath());
            }
            for (int i = this.mps.length; i >= 0; --i) {
                Object object;
                String string;
                FS fS2 = i == this.mps.length ? fS : this.mps[i].fs;
                String string2 = string = i == this.mps.length ? "" : this.mps[i].path;
                if (!(fS2 instanceof HostFS)) continue;
                File file2 = ((HostFS)fS2).getRoot();
                if (!file2.isAbsolute()) {
                    file2 = new File(file2.getAbsolutePath());
                }
                if (!file.getPath().startsWith(file2.getPath())) continue;
                char c = File.separatorChar;
                String string3 = file.getPath().substring(file2.getPath().length());
                if (c != '/') {
                    object = string3.toCharArray();
                    for (int j = 0; j < ((char[])object).length; ++j) {
                        if (object[j] == '/') {
                            object[j] = c;
                            continue;
                        }
                        if (object[j] != c) continue;
                        object[j] = 47;
                    }
                    string3 = new String((char[])object);
                }
                object = "/" + (string.length() == 0 ? "" : string + "/") + string3;
                return object;
            }
            return null;
        }

        public synchronized FS getMount(String string) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("Mount point doesn't start with a /");
            }
            if (string.equals("/")) {
                return this.root;
            }
            string = string.substring(1);
            for (int i = 0; i < this.mps.length; ++i) {
                if (!this.mps[i].path.equals(string)) continue;
                return this.mps[i].fs;
            }
            return null;
        }

        public synchronized void addMount(String string, FS fS) {
            if (this.getMount(string) != null) {
                throw new IllegalArgumentException("mount point already exists");
            }
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("Mount point doesn't start with a /");
            }
            if (fS.owner != null) {
                fS.owner.removeMount(fS);
            }
            fS.owner = this;
            if (string.equals("/")) {
                this.root = fS;
                fS.devno = 1;
                return;
            }
            string = string.substring(1);
            int n = this.mps.length;
            Sort.Comparable[] comparableArray = new MP[n + 1];
            if (n != 0) {
                System.arraycopy(this.mps, 0, comparableArray, 0, n);
            }
            comparableArray[n] = new MP(string, fS);
            Sort.sort(comparableArray);
            this.mps = comparableArray;
            int n2 = 0;
            for (int i = 0; i < this.mps.length; ++i) {
                n2 = Runtime.max(n2, this.mps[i].fs.devno);
            }
            fS.devno = n2 + 2;
        }

        public synchronized void removeMount(FS fS) {
            for (int i = 0; i < this.mps.length; ++i) {
                if (this.mps[i].fs != fS) continue;
                this.removeMount(i);
                return;
            }
            throw new IllegalArgumentException("mount point doesn't exist");
        }

        public synchronized void removeMount(String string) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("Mount point doesn't start with a /");
            }
            if (string.equals("/")) {
                this.removeMount(-1);
            } else {
                int n;
                string = string.substring(1);
                for (n = 0; n < this.mps.length && !this.mps[n].path.equals(string); ++n) {
                }
                if (n == this.mps.length) {
                    throw new IllegalArgumentException("mount point doesn't exist");
                }
                this.removeMount(n);
            }
        }

        private void removeMount(int n) {
            if (n == -1) {
                this.root.owner = null;
                this.root = null;
                return;
            }
            MP[] mPArray = new MP[this.mps.length - 1];
            System.arraycopy(this.mps, 0, mPArray, 0, n);
            System.arraycopy(this.mps, 0, mPArray, n, this.mps.length - n - 1);
            this.mps = mPArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object fsop(int n, UnixRuntime unixRuntime, String string, int n2, int n3) throws Runtime.ErrnoException {
            int n4 = string.length();
            if (n4 != 0) {
                MP[] mPArray;
                GlobalState globalState = this;
                synchronized (globalState) {
                    mPArray = this.mps;
                }
                for (int i = 0; i < mPArray.length; ++i) {
                    MP mP = mPArray[i];
                    int n5 = mP.path.length();
                    if (!string.startsWith(mP.path) || n4 != n5 && string.charAt(n5) != '/') continue;
                    return mP.fs.dispatch(n, unixRuntime, n4 == n5 ? "" : string.substring(n5 + 1), n2, n3);
                }
            }
            return this.root.dispatch(n, unixRuntime, string, n2, n3);
        }

        public final Runtime.FD open(UnixRuntime unixRuntime, String string, int n, int n2) throws Runtime.ErrnoException {
            return (Runtime.FD)this.fsop(1, unixRuntime, string, n, n2);
        }

        public final Runtime.FStat stat(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            return (Runtime.FStat)this.fsop(2, unixRuntime, string, 0, 0);
        }

        public final Runtime.FStat lstat(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            return (Runtime.FStat)this.fsop(3, unixRuntime, string, 0, 0);
        }

        public final void mkdir(UnixRuntime unixRuntime, String string, int n) throws Runtime.ErrnoException {
            this.fsop(4, unixRuntime, string, n, 0);
        }

        public final void unlink(UnixRuntime unixRuntime, String string) throws Runtime.ErrnoException {
            this.fsop(5, unixRuntime, string, 0, 0);
        }

        private static class CacheEnt {
            public final long time;
            public final long size;
            public final Object o;

            public CacheEnt(long l, long l2, Object object) {
                this.time = l;
                this.size = l2;
                this.o = object;
            }
        }

        static class MP
        implements Sort.Comparable {
            public String path;
            public FS fs;

            public MP(String string, FS fS) {
                this.path = string;
                this.fs = fS;
            }

            public int compareTo(Object object) {
                if (!(object instanceof MP)) {
                    return 1;
                }
                return -this.path.compareTo(((MP)object).path);
            }
        }
    }

    static class SocketFD
    extends Runtime.FD {
        public static final int TYPE_STREAM = 0;
        public static final int TYPE_DGRAM = 1;
        public static final int LISTEN = 2;
        int flags;
        int options;
        Socket s;
        ServerSocket ss;
        DatagramSocket ds;
        InetAddress bindAddr;
        int bindPort = -1;
        InetAddress connectAddr;
        int connectPort = -1;
        DatagramPacket dp;
        InputStream is;
        OutputStream os;
        private static final byte[] EMPTY = new byte[0];

        public int type() {
            return this.flags & 1;
        }

        public boolean listen() {
            return (this.flags & 2) != 0;
        }

        public SocketFD(int n) {
            this.flags = n;
            if (n == 1) {
                this.dp = new DatagramPacket(EMPTY, 0);
            }
        }

        public void setOptions() {
            try {
                if (this.s != null && this.type() == 0 && !this.listen()) {
                    Platform.socketSetKeepAlive(this.s, (this.options & 8) != 0);
                }
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
        }

        public void _close() {
            try {
                if (this.s != null) {
                    this.s.close();
                }
                if (this.ss != null) {
                    this.ss.close();
                }
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int read(byte[] byArray, int n, int n2) throws Runtime.ErrnoException {
            if (this.type() == 1) {
                return this.recvfrom(byArray, n, n2, null, null);
            }
            if (this.is == null) {
                throw new Runtime.ErrnoException(32);
            }
            try {
                int n3 = this.is.read(byArray, n, n2);
                return n3 < 0 ? 0 : n3;
            }
            catch (IOException iOException) {
                throw new Runtime.ErrnoException(5);
            }
        }

        public int recvfrom(byte[] byArray, int n, int n2, InetAddress[] inetAddressArray, int[] nArray) throws Runtime.ErrnoException {
            if (this.type() == 0) {
                return this.read(byArray, n, n2);
            }
            if (n != 0) {
                throw new IllegalArgumentException("off must be 0");
            }
            this.dp.setData(byArray);
            this.dp.setLength(n2);
            try {
                if (this.ds == null) {
                    this.ds = new DatagramSocket();
                }
                this.ds.receive(this.dp);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new Runtime.ErrnoException(5);
            }
            if (inetAddressArray != null) {
                inetAddressArray[0] = this.dp.getAddress();
                nArray[0] = this.dp.getPort();
            }
            return this.dp.getLength();
        }

        public int write(byte[] byArray, int n, int n2) throws Runtime.ErrnoException {
            if (this.type() == 1) {
                return this.sendto(byArray, n, n2, null, -1);
            }
            if (this.os == null) {
                throw new Runtime.ErrnoException(32);
            }
            try {
                this.os.write(byArray, n, n2);
                return n2;
            }
            catch (IOException iOException) {
                throw new Runtime.ErrnoException(5);
            }
        }

        public int sendto(byte[] byArray, int n, int n2, InetAddress inetAddress, int n3) throws Runtime.ErrnoException {
            if (n != 0) {
                throw new IllegalArgumentException("off must be 0");
            }
            if (this.type() == 0) {
                return this.write(byArray, n, n2);
            }
            if (inetAddress == null) {
                inetAddress = this.connectAddr;
                n3 = this.connectPort;
                if (inetAddress == null) {
                    throw new Runtime.ErrnoException(128);
                }
            }
            this.dp.setAddress(inetAddress);
            this.dp.setPort(n3);
            this.dp.setData(byArray);
            this.dp.setLength(n2);
            try {
                if (this.ds == null) {
                    this.ds = new DatagramSocket();
                }
                this.ds.send(this.dp);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if ("Network is unreachable".equals(iOException.getMessage())) {
                    throw new Runtime.ErrnoException(118);
                }
                throw new Runtime.ErrnoException(5);
            }
            return this.dp.getLength();
        }

        public int flags() {
            return 2;
        }

        public Runtime.FStat _fstat() {
            return new Runtime.SocketFStat();
        }
    }

    static class Pipe {
        private final byte[] pipebuf = new byte[2048];
        private int readPos;
        private int writePos;
        public final Runtime.FD reader = new Reader();
        public final Runtime.FD writer = new Writer();

        Pipe() {
        }

        public class Writer
        extends Runtime.FD {
            protected Runtime.FStat _fstat() {
                return new Runtime.SocketFStat();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int write(byte[] byArray, int n, int n2) throws Runtime.ErrnoException {
                if (n2 == 0) {
                    return 0;
                }
                Pipe pipe = Pipe.this;
                synchronized (pipe) {
                    if (Pipe.this.readPos == -1) {
                        throw new Runtime.ErrnoException(32);
                    }
                    if (Pipe.this.pipebuf.length - Pipe.this.writePos < Math.min(n2, 512)) {
                        while (Pipe.this.readPos != -1 && Pipe.this.readPos != Pipe.this.writePos) {
                            try {
                                Pipe.this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (Pipe.this.readPos == -1) {
                            throw new Runtime.ErrnoException(32);
                        }
                        Pipe.this.readPos = (Pipe.this.writePos = 0);
                    }
                    n2 = Math.min(n2, Pipe.this.pipebuf.length - Pipe.this.writePos);
                    System.arraycopy(byArray, n, Pipe.this.pipebuf, Pipe.this.writePos, n2);
                    if (Pipe.this.readPos == Pipe.this.writePos) {
                        Pipe.this.notify();
                    }
                    Pipe.this.writePos += n2;
                    return n2;
                }
            }

            public int flags() {
                return 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void _close() {
                Pipe pipe = Pipe.this;
                synchronized (pipe) {
                    Pipe.this.writePos = -1;
                    Pipe.this.notify();
                }
            }
        }

        public class Reader
        extends Runtime.FD {
            protected Runtime.FStat _fstat() {
                return new Runtime.SocketFStat();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(byte[] byArray, int n, int n2) throws Runtime.ErrnoException {
                if (n2 == 0) {
                    return 0;
                }
                Pipe pipe = Pipe.this;
                synchronized (pipe) {
                    while (Pipe.this.writePos != -1 && Pipe.this.readPos == Pipe.this.writePos) {
                        try {
                            Pipe.this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (Pipe.this.writePos == -1) {
                        return 0;
                    }
                    n2 = Math.min(n2, Pipe.this.writePos - Pipe.this.readPos);
                    System.arraycopy(Pipe.this.pipebuf, Pipe.this.readPos, byArray, n, n2);
                    Pipe.this.readPos += n2;
                    if (Pipe.this.readPos == Pipe.this.writePos) {
                        Pipe.this.notify();
                    }
                    return n2;
                }
            }

            public int flags() {
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void _close() {
                Pipe pipe = Pipe.this;
                synchronized (pipe) {
                    Pipe.this.readPos = -1;
                    Pipe.this.notify();
                }
            }
        }
    }

    public static final class ForkedProcess
    extends Thread {
        private final UnixRuntime initial;

        public ForkedProcess(UnixRuntime unixRuntime) {
            this.initial = unixRuntime;
            this.start();
        }

        public void run() {
            UnixRuntime.executeAndExec(this.initial);
        }
    }

    private static class ProcessTableFullExn
    extends RuntimeException {
        private ProcessTableFullExn() {
        }
    }
}

