/*
 * Decompiled with CFR 0.152.
 */
package filters;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.arnx.jsonic.JSON;
import util.IContext;

public class AuthFilter
implements Filter {
    private ServletContext scontext;

    private static IContext getContextInstance(HashMap<String, String> env, String myClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        IContext context = null;
        if (myClass != null) {
            System.err.printf("AuthFilter#getContextInstance: %s%n", myClass);
            Class<?> c = Class.forName(myClass);
            Constructor<?> cons = c.getConstructor(new Class[0]);
            context = (IContext)cons.newInstance(new Object[0]);
            context.configure(env);
            return context;
        }
        return context;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        this.scontext = fConfig.getServletContext();
    }

    public void destroy() {
    }

    public static IContext setContext(ServletContext scontext, HttpSession session, HttpServletRequest request) throws Exception {
        String documentBase;
        String config = request.getParameter("wappen.config");
        if (config == null) {
            config = scontext.getInitParameter("config");
        } else {
            System.err.printf("wappen.config is set (%s)%n", config);
        }
        String json = request.getParameter("wappen.json");
        if (json == null) {
            json = scontext.getInitParameter("json");
        }
        if ((documentBase = request.getParameter("wappen.documentBase")) == null) {
            scontext.getInitParameter("documentBase");
        }
        HashMap<String, String> env = AuthFilter.initEnv(request, config, json, request.getRequestURL().toString(), documentBase);
        IContext context = AuthFilter.createContext(env);
        System.err.printf("AuthFilter#setContext: session = %s%n", session.getId());
        System.err.printf("AuthFilter#setContext: context = %s%n", context);
        session.setAttribute("context", (Object)context);
        session.setAttribute("index", (Object)0);
        return context;
    }

    public static HashMap<String, String> initEnv(HttpServletRequest request, String config, String expr, String referer, String documentBase) throws MalformedURLException {
        String requestURI;
        URL configURL;
        HashMap env;
        block38: {
            env = null;
            System.err.printf("AuthFilter#initEnv: URL=%s%n", referer);
            System.err.printf("AuthFilter#initEnv:: config=%s%n", config);
            if (config != null) {
                configURL = referer != null ? new URL(new URL(referer), config) : new URL(config);
                Reader rd = null;
                try {
                    rd = new InputStreamReader(configURL.openStream(), "UTF-8");
                    env = (HashMap)JSON.decode((Reader)rd);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    try {
                        rd.close();
                    }
                    catch (IOException iOException) {}
                    break block38;
                }
                catch (IOException e) {
                    try {
                        System.err.printf("failed to read %s%n", configURL.toExternalForm());
                        e.printStackTrace();
                        break block38;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            rd.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    rd.close();
                }
                catch (IOException iOException) {}
            } else {
                if (expr != null) {
                    env = (HashMap)JSON.decode((String)expr);
                }
                configURL = null;
            }
        }
        if (env == null) {
            env = new HashMap();
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String value;
            String name = (String)names.nextElement();
            if (name.startsWith("config.")) {
                value = request.getParameter(name);
                name = name.substring("config.".length());
                env.put(name, value);
                continue;
            }
            if (!name.startsWith("wappen.")) continue;
            value = request.getParameter(name);
            name = name.substring("wappen.".length());
            env.put(name, value);
        }
        String baseURLString = null;
        if (env.containsKey("baseURL")) {
            baseURLString = (String)env.get("baseURL");
            try {
                new URL(baseURLString);
            }
            catch (MalformedURLException e) {
                URL parent = null;
                if (documentBase != null) {
                    parent = new URL(documentBase);
                } else if (configURL != null) {
                    parent = configURL;
                } else if (referer != null) {
                    parent = new URL(referer);
                }
                if (parent != null) {
                    URL absolute = new URL(parent, baseURLString);
                    env.put("baseURL", absolute.toExternalForm());
                }
            }
        } else {
            if (documentBase != null) {
                baseURLString = documentBase;
            } else if (configURL != null) {
                baseURLString = configURL.toExternalForm();
            } else if (referer != null) {
                baseURLString = referer;
            }
            if (baseURLString != null) {
                env.put("baseURL", baseURLString);
            }
        }
        if ((requestURI = request.getRequestURI()) != null) {
            env.put("requestURI", requestURI);
        }
        return env;
    }

    public static IContext createContext(HashMap<String, String> env) throws Exception {
        String myClass = env.get("class");
        System.err.printf("AuthFilter#setContext: class=%s%n", myClass);
        if (myClass == null) {
            return null;
        }
        IContext context = null;
        try {
            context = AuthFilter.getContextInstance(env, myClass);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req0, ServletResponse res0, FilterChain chain) throws IOException, ServletException {
        IContext context;
        HttpServletRequest request = (HttpServletRequest)req0;
        HttpServletResponse response = (HttpServletResponse)res0;
        request.setCharacterEncoding("UTF-8");
        HttpSession session = request.getSession();
        String origin = request.getHeader("Origin");
        String method = request.getMethod();
        if (origin != null && method.equals("OPTIONS")) {
            chain.doFilter(req0, res0);
            return;
        }
        AuthFilter authFilter = this;
        synchronized (authFilter) {
            context = (IContext)session.getAttribute("context");
            if (context == null) {
                try {
                    context = AuthFilter.setContext(this.scontext, session, request);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (context == null) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        if (!AuthFilter.setAccount(response, session, context)) {
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setAccount(HttpServletResponse response, HttpSession session, IContext context) throws IOException {
        boolean needAuthentication = context.isAuthenticationNecessary();
        HttpSession httpSession = session;
        synchronized (httpSession) {
            block6: {
                block8: {
                    String account;
                    block7: {
                        account = (String)session.getAttribute("account");
                        if (account != null) break block6;
                        if (!needAuthentication) break block7;
                        response.sendError(401, "<span style='color:red'>need authentication.</span>");
                        return false;
                    }
                    account = "anonymous";
                    if (!context.start(account, "")) break block8;
                    session.setAttribute("account", (Object)account);
                    return true;
                }
                System.err.println("context.start failure");
                return false;
            }
            return true;
        }
    }

    static String originalURL(HttpServletRequest request) {
        StringBuffer originalURL = request.getRequestURL();
        String qs = request.getQueryString();
        if (qs != null && !qs.equals("")) {
            qs = qs.replace("&", "%26");
            qs = qs.replace("=", "%3d");
            originalURL.append("?");
            originalURL.append(qs);
        }
        return originalURL.toString();
    }
}

