/*
 * Decompiled with CFR 0.152.
 */
package check;

import java.net.URI;
import java.util.regex.Pattern;

public class CheckURI {
    private static final String[] myHosts = new String[]{"http://guppy.eng.kagawa-u.ac.jp/", "http://platy.eng.kagawa-u.ac.jp/", "http://ymir.eng.kagawa-u.ac.jp/", "http://localhost/", "http://127.0.0.1/"};
    private static final String oct = "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
    private static final String[] myHostsRegexp = new String[]{"http://192\\.168\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/.*", "http://172\\.(1[6-9]|2[0-9]|3[01])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/.*", "http://10\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/.*"};
    private static final String myName = "WappenLite";

    public static final boolean checkURI(URI uri, URI refererURI) {
        if (refererURI != null && uri.getScheme().equals(refererURI.getScheme()) && uri.getHost().equals(refererURI.getHost()) && uri.getPort() == refererURI.getPort() && uri.getPath().contains(myName)) {
            return true;
        }
        String uriStr = uri.toString();
        if (uri.getPath().contains(myName)) {
            String u;
            String[] stringArray = myHosts;
            int n = myHosts.length;
            int n2 = 0;
            while (n2 < n) {
                u = stringArray[n2];
                if (uriStr.startsWith(u)) {
                    return true;
                }
                ++n2;
            }
            stringArray = myHostsRegexp;
            n = myHostsRegexp.length;
            n2 = 0;
            while (n2 < n) {
                u = stringArray[n2];
                if (Pattern.matches(u, uriStr)) {
                    return true;
                }
                ++n2;
            }
        }
        System.err.printf("checkURI failed for %s. Please read the WappenLite document and see check/CheckURI.java.%n", uriStr);
        return false;
    }
}

