/*
 * Decompiled with CFR 0.152.
 */
package servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.arnx.jsonic.JSON;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import util.AbstractContext;
import util.IConnection;
import util.IContext;

public class Connect
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        final IContext context = AbstractContext.getCurrentContext(request);
        if (context == null) {
            return null;
        }
        return new WebSocket.OnTextMessage(){
            IConnection out;

            public void onOpen(final WebSocket.Connection outb) {
                this.out = new IConnection(){
                    private String str = "";

                    @Override
                    public void send(ArrayList<HashMap<String, Object>> json) throws IOException {
                        String tmp = String.valueOf(JSON.encode(json)) + "\r\n";
                        if (outb.isOpen()) {
                            outb.sendMessage(String.valueOf(this.str) + tmp);
                            this.str = "";
                        } else {
                            this.str = String.valueOf(this.str) + tmp;
                        }
                    }

                    @Override
                    public void send(HashMap<String, Object> json) throws IOException {
                        ArrayList<HashMap<String, Object>> sent = new ArrayList<HashMap<String, Object>>();
                        sent.add(json);
                        this.send(sent);
                    }

                    @Override
                    public void close() throws IOException {
                        if (outb.isOpen()) {
                            if (this.str.length() > 0) {
                                outb.sendMessage(this.str);
                            }
                            outb.disconnect();
                        }
                    }

                    @Override
                    public boolean isOpen() {
                        return outb.isOpen();
                    }
                };
                context.connect(this.out);
            }

            public void onClose(int arg0, String arg1) {
                context.disconnect(this.out);
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void onMessage(String message) {
                String args;
                String pIndex;
                HashMap json = (HashMap)JSON.decode((String)message);
                String input = (String)json.get("write#message");
                if (input != null) {
                    try {
                        context.write(String.format("%s%n", input));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((pIndex = (String)json.get("read#index")) != null) {
                    String pReset = json != null ? (String)json.get("read#reset") : null;
                    boolean reset = pReset != null && pReset.equalsIgnoreCase("true");
                    try {
                        int index = Integer.parseInt(pIndex);
                        if (reset) {
                            context.reset();
                        }
                        ArrayList<HashMap<String, Object>> content = context.read(index);
                        this.out.send(content);
                    }
                    catch (NumberFormatException e) {
                        System.err.printf("Connect#onMessage: cannot parse index (%s)%n", pIndex);
                    }
                    catch (IOException e) {
                        System.err.printf("Connect#onMessage: context.read() failed.%n", new Object[0]);
                    }
                }
                if ((args = (String)json.get("run#args")) != null) {
                    try {
                        context.run(args.split("\\s+"));
                    }
                    catch (IOException e) {
                        System.err.printf("Connect#onMessage: context.run(%s) failed.%n", args);
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        if (origin == null) {
            System.err.printf("Origin is null\r\n", new Object[0]);
        }
        return true;
    }
}

