/*
 * Decompiled with CFR 0.152.
 */
package servlets;

import filters.AuthFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.arnx.jsonic.JSON;
import util.IContext;

public class Login
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        request.setCharacterEncoding("UTF-8");
        String account = request.getParameter("account");
        String passwd = request.getParameter("passwd");
        String url = request.getParameter("url");
        String referer = request.getParameter("referer");
        HttpSession session = request.getSession();
        String config = request.getParameter("config");
        String expr = request.getParameter("json");
        if (referer == null) {
            referer = request.getHeader("Referer");
        }
        HashMap<String, String> env = AuthFilter.initEnv(request, config, expr, referer, null);
        String contextIdStr = request.getParameter("contextId");
        int contextId = -1;
        ArrayList<IContext> contextList = (ArrayList<IContext>)session.getAttribute("contextList");
        if (contextList == null) {
            contextList = new ArrayList<IContext>();
            session.setAttribute("contextList", contextList);
        }
        IContext context = null;
        try {
            contextId = Integer.parseInt(contextIdStr);
            context = (IContext)contextList.get(contextId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (context == null) {
            if (config == null && expr == null) {
                response.sendError(400, "<span style='color:red'>Login: Either config or json must be specified.</span>");
                return;
            }
            try {
                String envJSON;
                Integer contextIdN;
                HashMap<String, Integer> contextMap = (HashMap<String, Integer>)session.getAttribute("contextMap");
                if (contextMap == null) {
                    contextMap = new HashMap<String, Integer>();
                    session.setAttribute("contextMap", contextMap);
                }
                if ((contextIdN = (Integer)contextMap.get(envJSON = JSON.encode(env))) != null) {
                    contextId = contextIdN;
                    context = (IContext)contextList.get(contextId);
                } else {
                    context = AuthFilter.createContext(env);
                    contextId = contextList.size();
                    contextList.add(context);
                    contextMap.put(envJSON, contextId);
                }
                request.setAttribute("contextId", (Object)contextId);
            }
            catch (Exception e) {
                System.err.println("Login: context initialization failure!");
                response.sendError(400, "<span style='color:red'>context initialization failure!</span>");
                return;
            }
        }
        if (config != null || expr != null) {
            try {
                context.configure(env);
            }
            catch (Exception e) {
                System.err.println("configure failed");
                e.printStackTrace();
                response.sendError(403, e.getMessage());
            }
        }
        if (account != null) {
            if (!this.setAcccount(response, context, account, passwd)) {
                return;
            }
        } else {
            AuthFilter.setAccount(request, response, context);
        }
        if (url != null) {
            String urlX = url.replace("%26", "&").replace("%3d", "=");
            if (referer != null) {
                urlX = urlX.lastIndexOf(63) >= 0 ? String.valueOf(urlX) + "&referer=" + referer + "&contextId=" + contextId : String.valueOf(urlX) + "?referer=" + referer + "&contextId=" + contextId;
            }
            response.sendRedirect(response.encodeRedirectURL(urlX));
            return;
        }
        response.setContentType("text/plain; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.printf("{ \"contextId\": %d }\r\n", contextId);
        out.close();
    }

    private boolean setAcccount(HttpServletResponse response, IContext context, String account, String passwd) throws IOException {
        String account0 = context.getAccount();
        if (account0 == null || account0 != account) {
            try {
                if (context.start(account, passwd)) {
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.err.println("Invalid Login/Password");
            response.sendError(403, "Invalid Login/Password");
            return false;
        }
        return true;
    }
}

