/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.PrintWriter;

public class EscapeWriter
extends PrintWriter {
    PrintWriter writer;
    String style;

    public EscapeWriter(PrintWriter out, String style) {
        super(out);
        this.writer = out;
        this.style = style;
    }

    public EscapeWriter(PrintWriter out) {
        this(out, null);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.write(new String(cbuf, off, len));
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(int c) {
        this.write(new char[]{(char)c});
    }

    @Override
    public void write(String str) {
        if (this.style != null) {
            this.writer.write("<span style='" + this.style + "'>" + str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;") + "</span>");
        } else {
            this.writer.write(str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        }
    }

    @Override
    public void write(String s, int off, int len) {
        this.write(s.substring(off, off + len));
    }
}

