/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import util.AbstractContext;
import util.ContextBuffer;
import util.IConnection;

public class TrivialContext
extends AbstractContext {
    protected OutputStream out = null;
    protected ContextBuffer buf;
    protected Process process = null;
    private boolean running = false;
    protected ArrayList<IConnection> connections = new ArrayList();
    protected String account = null;
    protected int index = 0;

    public void setRunning(boolean r) {
        if (this.running != r) {
            this.running = r;
            this.addStatus("running", "" + r);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected HashMap<String, Object> checkWatchedDir() {
        File outfile;
        long mtime;
        Long last;
        HashMap<String, Object> ret = null;
        if (this.output != null && ((last = (Long)this.watched.get(this.output)) == null ? 0L : last) < (mtime = (outfile = new File(this.baseDir, this.output)).lastModified())) {
            ret = new HashMap<String, Object>();
            this.watched.put(this.output, mtime);
            ret.put(this.output, mtime);
        }
        if (this.watchDir == null) {
            return ret;
        }
        File dir = new File(this.baseDir, this.watchDir);
        if (!dir.exists() || !dir.isDirectory()) {
            System.err.printf("Directory (%s) does not exist / is not a directory.%n", this.watchDir);
            return ret;
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = f.getName();
            Long last2 = (Long)this.watched.get(name);
            long mtime2 = f.lastModified();
            if (last2 == null || last2 < mtime2) {
                if (this.watchDir.length() > 0) {
                    name = String.valueOf(this.watchDir) + "/" + name;
                }
                if (ret == null) {
                    ret = new HashMap();
                }
                this.watched.put(name, mtime2);
                ret.put(name, mtime2);
            }
            ++n2;
        }
        return ret;
    }

    @Override
    public void configure(HashMap<String, String> map) throws Exception {
        super.configure(map);
        if (this.buf == null) {
            this.buf = new ContextBuffer();
        }
        this.loadContents();
    }

    @Override
    public String write(String str) throws IOException {
        if (this.out == null) {
            return "{}";
        }
        this.addMessage("ECHO", str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        try {
            this.out.write(str.getBytes("UTF-8"));
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{}";
        }
        return "{}";
    }

    @Override
    public String eof() throws IOException {
        if (this.out == null) {
            return "{}";
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{}";
        }
        return "{}";
    }

    @Override
    public String abort() {
        if (this.process != null) {
            this.process.destroy();
        }
        return "{}";
    }

    private static boolean shouldCheckWatchedDir(ArrayList<HashMap<String, Object>> json) {
        for (HashMap<String, Object> pack : json) {
            Object kind = pack.get("kind");
            if (kind != "STDOUT" && kind != "ERROR" || !((String)pack.get("output")).contains("\n")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<HashMap<String, Object>> read(int index, int length) throws IOException {
        ArrayList<HashMap<String, Object>> ret = this.buf.toJSONArrayWithIndex(index, length);
        if (TrivialContext.shouldCheckWatchedDir(ret)) {
            this.notifyUpdatedFiles();
            ret = this.buf.toJSONArrayWithIndex(index, length);
        }
        return ret;
    }

    @Override
    public ArrayList<HashMap<String, Object>> read(int index) throws IOException {
        ArrayList<HashMap<String, Object>> ret = this.buf.toJSONArrayWithIndex(index, -1);
        if (TrivialContext.shouldCheckWatchedDir(ret)) {
            this.notifyUpdatedFiles();
            ret = this.buf.toJSONArrayWithIndex(index, -1);
        }
        return ret;
    }

    @Override
    public ArrayList<HashMap<String, Object>> read() throws IOException {
        ArrayList<HashMap<String, Object>> ret = this.buf.toJSONArray();
        if (TrivialContext.shouldCheckWatchedDir(ret)) {
            this.notifyUpdatedFiles();
            ret = this.buf.toJSONArray();
        }
        return ret;
    }

    @Override
    public ArrayList<HashMap<String, Object>> receive() throws IOException {
        return this.read();
    }

    @Override
    public ArrayList<HashMap<String, Object>> receive(int begin) throws IOException {
        ArrayList<HashMap<String, Object>> ret = this.buf.toJSONArray(begin);
        if (TrivialContext.shouldCheckWatchedDir(ret)) {
            this.notifyUpdatedFiles();
            ret = this.buf.toJSONArray(begin);
        }
        return ret;
    }

    @Override
    public ArrayList<HashMap<String, Object>> receive(int begin, int num) throws IOException {
        ArrayList<HashMap<String, Object>> ret = this.buf.toJSONArray(begin, num);
        if (TrivialContext.shouldCheckWatchedDir(ret)) {
            this.notifyUpdatedFiles();
            ret = this.buf.toJSONArray(begin, num);
        }
        return ret;
    }

    @Override
    public boolean waitForRead(int index) throws IOException {
        this.buf.waitForInput(index);
        return true;
    }

    @Override
    public boolean waitForReceive() throws IOException {
        return this.waitForReceive(0);
    }

    @Override
    public boolean waitForReceive(int serial) throws IOException {
        this.buf.waitForPacket(serial);
        return true;
    }

    @Override
    public synchronized void connect(IConnection out) {
        this.connections.add(out);
    }

    @Override
    public void disconnect(IConnection out) {
        this.connections.remove(out);
    }

    public void addMessage(String k, String s) {
        HashMap<String, Object> newPair = this.buf.newMessagePacket(k, s);
        this.addToBuf(newPair);
        if (s.contains("\n")) {
            this.notifyUpdatedFiles();
        }
    }

    public void addStatus(String k, Object s) {
        HashMap<String, Object> newPair = this.buf.newStatusPacket(k, s);
        this.addToBuf(newPair);
    }

    private void addToBuf(HashMap<String, Object> newPair) {
        this.buf.addPacket(newPair);
        this.sendPacket(newPair);
    }

    private void sendPacket(HashMap<String, Object> newPair) {
        for (IConnection out : this.connections) {
            try {
                out.send(newPair);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public HashMap<String, Object> getStatus() {
        HashMap<String, Object> watched = this.checkWatchedDir();
        if (watched != null && watched.size() > 0) {
            this.status.put("watchDir", watched);
        }
        this.status.put("running", this.running);
        return super.getStatus();
    }

    protected void notifyUpdatedFiles() {
        HashMap<String, Object> watched = this.checkWatchedDir();
        if (watched != null && watched.size() > 0) {
            this.addStatus("watchDir", watched);
        }
    }

    public Thread connectStream(String k, InputStream in) {
        return this.connectStream(k, in, null);
    }

    public Thread connectStream(String k, InputStream in, OutputStream out) {
        return this.connectStream(k, in, out, true);
    }

    public Thread connectStream(final String k, final InputStream in, final OutputStream out, final boolean convert) {
        Thread t = new Thread(){
            byte[] bytes = new byte[1024];

            @Override
            public void run() {
                try {
                    while (true) {
                        int len;
                        if ((len = in.read(this.bytes)) < 0) {
                            in.close();
                            if (out != null) {
                                out.close();
                            }
                            return;
                        }
                        String str = new String(this.bytes, 0, len);
                        if (convert) {
                            str = str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                        }
                        System.out.print(str);
                        TrivialContext.this.addMessage(k, str);
                        if (out != null) {
                            out.write(this.bytes, 0, len);
                            out.flush();
                        }
                        1.yield();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        t.start();
        return t;
    }

    public PrintWriter getWriter(String k) {
        return this.getWriter(k, false);
    }

    public PrintWriter getWriter(final String k, final boolean convert) {
        Writer w = new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(String str) throws IOException {
                if (convert) {
                    str = str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                }
                System.out.print(str);
                TrivialContext.this.addMessage(k, str);
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                String s = new String(cbuf, off, len);
                this.write(s);
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                String s = str.substring(off, off + len);
                this.write(s);
            }

            @Override
            public void write(int c) throws IOException {
                this.write(String.valueOf((char)c));
            }
        };
        return new PrintWriter(w);
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    @Override
    public void setAccount(String a) {
        this.account = a;
    }

    @Override
    public boolean start(String account, String passwd) throws IOException {
        boolean ret = super.start(account, passwd);
        this.setAccount(account);
        return ret;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    OutputStream getOutputStream(String k) {
        return this.getOutputStream(k, false);
    }

    OutputStream getOutputStream(final String k, final boolean convert) {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)(b / 256)});
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                String s = new String(b, off, len, "UTF-8");
                if (convert) {
                    s = s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                }
                System.out.print(s);
                TrivialContext.this.addMessage(k, s);
            }
        };
        return os;
    }
}

