/*
 * Decompiled with CFR 0.152.
 */
package servlets;

import check.CheckURI;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.arnx.jsonic.JSON;
import util.IContext;

public class Save
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static HashMap<String, String> contents = null;

    public void init(ServletConfig config) throws ServletException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        if (!Save.checkReferer(request, response)) {
            return;
        }
        IContext context = (IContext)session.getAttribute("context");
        if (context == null) {
            System.err.println("Save: context initialization failure!");
            response.sendError(400, "<span style='color:red'>Context not ready.</span>");
            return;
        }
        response.setContentType("text/html; charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        String saveParam = request.getParameter("save");
        HashMap<String, String> map = saveParam != null ? (HashMap<String, String>)JSON.decode((String)saveParam) : new HashMap<String, String>();
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String param = (String)parameters.nextElement();
            if (!param.startsWith("edit:")) continue;
            String save = request.getParameter(param);
            param = param.substring("edit:".length());
            map.put(param, save);
        }
        int count = 0;
        boolean flag = false;
        String ret = "";
        for (String param : map.keySet()) {
            ++count;
            String save = (String)map.get(param);
            String tmp = context.save(param, save);
            if (tmp == null) continue;
            ret = String.valueOf(ret) + tmp;
            flag = true;
        }
        PrintWriter out = response.getWriter();
        if (!flag) {
            out.printf("\"Compilation Succeeded %d.\"%n", count);
        } else {
            out.printf(ret, new Object[0]);
        }
        out.close();
    }

    static boolean checkReferer(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String referer = request.getHeader("Referer");
        if (referer == null) {
            String message = "referer null not allowed.";
            System.err.println(message);
            response.sendError(403, message);
            return false;
        }
        try {
            URI refererURI = new URI(request.getRequestURI()).resolve(referer);
            if (!CheckURI.checkURI(refererURI)) {
                String message = String.format("referer %s not allowed. Please read the WappenLite document and see check/CheckURI.java.", referer);
                System.err.println(message);
                response.sendError(403, message);
                return false;
            }
        }
        catch (URISyntaxException e) {
            response.sendError(500, "impossible.");
            return false;
        }
        return true;
    }
}

