/*
 * Decompiled with CFR 0.152.
 */
package servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import util.AbstractContext;
import util.IContext;

public class View
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ServletContext scontext;
    public static HashMap<String, String> aExtMap = View.prepareAExtMap();
    public static HashMap<String, String> bExtMap = View.prepareBExtMap();

    public void init(ServletConfig config) throws ServletException {
        this.scontext = config.getServletContext();
    }

    public static HashMap<String, String> prepareAExtMap() {
        HashMap<String, String> extMap = new HashMap<String, String>();
        extMap.put("svg", "image/svg+xml");
        extMap.put("x3d", "model/x3d+xml");
        extMap.put("dae", "text/xml");
        extMap.put("xml", "text/xml");
        extMap.put("json", "application/json");
        extMap.put("html", "text/html");
        extMap.put("htm", "text/html");
        extMap.put("txt", "text/plain");
        extMap.put("js", "text/javascript");
        extMap.put("ps", "application/postscript");
        extMap.put("eps", "application/postscript");
        String[] stringArray = new String[]{"c", "c++", "cpp", "java", "scala", "j", "y", "l", "lex", "jflex", "jacc", "mk", "makefile", "hs", "lhs", "s", "scm", "pl", "ruby", "rb", "perl", "py", "php"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extMap.put(ext, "text/plain");
            ++n2;
        }
        return extMap;
    }

    public static HashMap<String, String> prepareBExtMap() {
        HashMap<String, String> extMap = new HashMap<String, String>();
        extMap.put("bmp", "image/x-ms-bmp");
        extMap.put("png", "image/png");
        extMap.put("jpeg", "image/jpeg");
        extMap.put("jpg", "image/jpg");
        extMap.put("zip", "application/zip");
        extMap.put("pdf", "application/pdf");
        extMap.put("mid", "audio/midi");
        extMap.put("wav", "audio/wav");
        return extMap;
    }

    public static String getExtention(String name) {
        int idx = name.lastIndexOf(".");
        return name.substring(idx + 1).toLowerCase();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter("path");
        if (!this.safePath(path)) {
            System.err.printf("Invalid path %s%n", path);
            response.sendError(403, "Invalid path");
            return;
        }
        IContext context = AbstractContext.getCurrentContext(request);
        if (context == null) {
            System.err.println("Save: context initialization failure!");
            response.sendError(400, "<span style='color:red'>Context not ready.</span>");
            return;
        }
        String ext = View.getExtention(path);
        String type = aExtMap.get(ext);
        if (type != null) {
            type = String.valueOf(type) + String.format("; charset = %s", context.getEncoding());
        } else {
            type = bExtMap.get(ext);
            if (type == null) {
                type = this.scontext.getMimeType(path);
            }
            if (type == null) {
                type = "application/octet-stream";
            }
        }
        response.setContentType(type);
        ServletOutputStream out = response.getOutputStream();
        context.view(path, (OutputStream)out);
    }

    private boolean safePath(String path) {
        String[] dirs;
        if (path.startsWith("/") || path.startsWith("\\")) {
            return false;
        }
        String[] stringArray = dirs = path.split("/|\\\\");
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            if (dir.equals("..")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

