/*
 * Decompiled with CFR 0.152.
 */
package util;

import check.CheckURI;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.arnx.jsonic.JSON;
import servlets.View;
import util.IContext;

public abstract class AbstractContext
implements IContext {
    protected HashMap<String, Object> status = new HashMap();
    protected HashMap<String, String> properties;
    protected String baseURL;
    protected URI refererURI = null;
    protected File baseDir = null;
    protected HashMap<String, String> content;
    protected boolean contentChanged = false;
    protected HashMap<String, URL> origin;
    protected String[] sources = null;
    protected String[] hiddens = null;
    protected String[] targets = null;
    protected String[] jars = null;
    protected String classpath = "";
    protected String output = null;
    protected String upload = null;
    protected String encoding = null;
    protected String watchDir = null;
    protected HashMap<String, Long> watched;

    @Override
    public String getUpload() {
        return this.upload;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    protected AbstractContext() {
        this.mkWorkingDir();
    }

    private void mkWorkingDir() {
        String tmp = System.getProperty("java.io.tmpdir");
        long time = System.currentTimeMillis();
        String name = String.format("Project%1$ty%1$tm%1$td%1$tH%1$tM%1$tS%1$tL", time);
        this.baseDir = new File(tmp, name);
        this.baseDir.mkdirs();
    }

    protected void initialize(HashMap<String, String> map) throws IOException {
        this.properties = map;
        this.baseURL = this.properties.get("baseURL");
        this.origin = new HashMap();
        String wappenSources = this.properties.get("sources");
        this.sources = wappenSources != null ? wappenSources.split("\\s+") : new String[0];
        String wappenHiddens = this.properties.get("hiddens");
        this.hiddens = wappenHiddens != null ? wappenHiddens.split("\\s+") : new String[0];
        String wappenJars = this.properties.get("jars");
        this.jars = wappenJars != null ? wappenJars.split("\\s+") : new String[0];
        String wappenTargets = this.properties.get("targets");
        this.targets = wappenTargets != null ? wappenTargets.split("\\s+") : new String[0];
        this.output = this.properties.get("output");
        this.upload = this.properties.get("upload");
        this.encoding = this.properties.get("encoding");
        this.watchDir = this.properties.get("watchDir");
        if (this.watchDir != null) {
            new File(this.baseDir, this.watchDir).mkdirs();
        }
        this.content = new HashMap();
        this.watched = new HashMap();
        String refererURIString = this.properties.get("refererURI");
        if (refererURIString != null) {
            try {
                this.refererURI = new URI(refererURIString);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public void configure(HashMap<String, String> map) throws Exception {
        this.initialize(map);
    }

    @Override
    public String eof() throws IOException {
        return "{}";
    }

    @Override
    public void load(Appendable out) throws IOException {
        String[] stringArray = this.sources;
        int n = this.sources.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (this.content.get(path) == null) {
                StringBuilder sb = new StringBuilder();
                File f = new File(this.baseDir, path);
                if (f.exists()) {
                    String line;
                    BufferedReader br = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), this.encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                    this.content.put(path, sb.toString());
                }
            }
            ++n2;
        }
        JSON.encode(this.content, (Appendable)out);
    }

    @Override
    public String load() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.load(sb);
        return sb.toString();
    }

    @Override
    public void load(String path, Appendable out) throws IOException {
        if (this.content.get(path) == null) {
            String line;
            File f = new File(this.baseDir, path);
            if (!f.exists()) {
                throw new IOException("Invalid path: " + path);
            }
            BufferedReader br = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), this.encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                out.append(line);
                out.append("\n");
                sb.append(line);
                sb.append("\n");
            }
            br.close();
            this.content.put(path, sb.toString());
        } else {
            out.append(this.content.get(path));
        }
    }

    @Override
    public String load(String path) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.load(path, sb);
        return sb.toString();
    }

    protected void loadContents() throws IOException {
        String path;
        String[] stringArray = this.sources;
        int n = this.sources.length;
        int n2 = 0;
        while (n2 < n) {
            path = stringArray[n2];
            this.downloadTextFileWithPath(path);
            ++n2;
        }
        stringArray = this.hiddens;
        n = this.hiddens.length;
        n2 = 0;
        while (n2 < n) {
            path = stringArray[n2];
            String ext = View.getExtention(path);
            if (View.aExtMap.get(ext) != null) {
                this.downloadTextFileWithPath(path);
            } else {
                this.downloadBinaryFileWithPath(path);
            }
            ++n2;
        }
        stringArray = this.jars;
        n = this.jars.length;
        n2 = 0;
        while (n2 < n) {
            path = stringArray[n2];
            File f = this.downloadBinaryFileWithPath(path);
            if (f != null) {
                this.classpath = String.valueOf(this.classpath) + f.getCanonicalPath();
                this.classpath = String.valueOf(this.classpath) + File.pathSeparator;
            }
            ++n2;
        }
    }

    protected File downloadBinaryFileWithPath(String path) throws MalformedURLException, IOException, FileNotFoundException {
        String rPath;
        URL url0 = this.baseURL == null ? null : new URL(this.baseURL);
        int pos = path.indexOf(64);
        if (pos < 0) {
            rPath = path;
        } else {
            rPath = path.substring(pos + 1);
            path = path.substring(0, pos);
        }
        URL url = new URL(url0, rPath);
        URL url1 = this.origin.get(path);
        if (url1 != null && url1.equals(url)) {
            return null;
        }
        File f = new File(this.baseDir, path);
        f.getParentFile().mkdirs();
        this.downloadBinaryFile(url, f);
        this.origin.put(path, url);
        return f;
    }

    protected void downloadBinaryFile(URL url, File f) throws IOException, FileNotFoundException {
        int len;
        try {
            if (!CheckURI.checkURI(url.toURI(), this.refererURI)) {
                String message = String.format("Illegal URL %s for requestURI %s: Please read the WappenLite document and see check/CheckURI.java.", url.toExternalForm(), this.refererURI);
                System.err.println(message);
                throw new IOException(message);
            }
        }
        catch (URISyntaxException e) {
            String message = String.format("Illegal URL %s", url.toExternalForm());
            System.err.println(message);
            throw new IOException(message);
        }
        InputStream uin = url.openStream();
        File ftmp = new File(String.valueOf(f.getCanonicalPath()) + ".tmp");
        FileOutputStream fout = new FileOutputStream(ftmp);
        byte[] buf = new byte[1024];
        while ((len = uin.read(buf)) >= 0) {
            fout.write(buf, 0, len);
        }
        uin.close();
        fout.close();
        if (f.exists()) {
            f.delete();
        }
        ftmp.renameTo(f);
    }

    protected File downloadTextFileWithPath(String path) throws MalformedURLException, IOException, FileNotFoundException {
        String rPath;
        URL url0 = this.baseURL == null ? null : new URL(this.baseURL);
        int pos = path.indexOf(64);
        if (pos < 0) {
            rPath = path;
        } else {
            rPath = path.substring(pos + 1);
            path = path.substring(0, pos);
        }
        URL url = new URL(url0, rPath);
        URL url1 = this.origin.get(path);
        if (url1 != null && url1.equals(url)) {
            return null;
        }
        File f = new File(this.baseDir, path);
        f.getParentFile().mkdirs();
        this.downloadTextFile(url, f);
        this.origin.put(path, url);
        return f;
    }

    protected void downloadTextFile(URL url, File f) throws IOException {
        String line;
        try {
            if (!CheckURI.checkURI(url.toURI(), this.refererURI)) {
                String message = String.format("Illegal URL %s for requestURI %s: Please read the WappenLite document and see check/CheckURI.java.", url.toExternalForm(), this.refererURI);
                System.err.println(message);
                throw new IOException(message);
            }
        }
        catch (URISyntaxException e) {
            String message = String.format("Illegal URL %s", url.toExternalForm());
            System.err.println(message);
            throw new IOException(message);
        }
        URLConnection conn = url.openConnection();
        String enc = conn.getContentEncoding();
        if (enc == null) {
            enc = AbstractContext.getEncFromContentType(conn.getContentType());
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), enc));
        File ftmp = new File(String.valueOf(f.getCanonicalPath()) + ".tmp");
        OutputStreamWriter fw = this.encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(ftmp), this.encoding) : new OutputStreamWriter(new FileOutputStream(ftmp));
        while ((line = br.readLine()) != null) {
            fw.append(line);
            fw.append('\n');
        }
        br.close();
        fw.close();
        if (f.exists()) {
            f.delete();
        }
        ftmp.renameTo(f);
    }

    public static String getEncFromContentType(String contentType) {
        String type = contentType.toLowerCase();
        int idx = type.indexOf("charset");
        if (idx < 0) {
            return "utf-8";
        }
        if ((idx = (type = type.substring(idx + "charset".length())).indexOf(61)) < 0) {
            return "utf-8";
        }
        if ((idx = (type = type.substring(idx + 1)).indexOf(59)) > -1) {
            type = type.substring(0, idx);
        }
        type = type.replace("\"", "").trim();
        return type;
    }

    @Override
    public ArrayList<HashMap<String, Object>> read() throws IOException {
        return this.read(0);
    }

    @Override
    public void reset() {
    }

    protected String findJavaExecutable() {
        String[] candidates;
        String home = System.getProperty("java.home");
        String[] stringArray = candidates = new String[]{"bin/java", "bin/java.exe", "jre/bin/java", "jre/bin/java.exe"};
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String can = stringArray[n2];
            File f = new File(home, can);
            if (f.exists()) {
                try {
                    String path = f.getCanonicalPath();
                    return path;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return "java";
    }

    protected void uploadFile(String path, String upload) throws IOException {
        BufferedReader br;
        String redirectURL;
        URL url0 = this.baseURL == null ? null : new URL(this.baseURL);
        URL uploadURL = new URL(url0, upload);
        URLConnection urlCon = uploadURL.openConnection();
        urlCon.setDoOutput(true);
        urlCon.setUseCaches(false);
        urlCon.setRequestProperty("Content-Type", String.format("multipart/form-data; boundary=%s", "----------------3243F6A8885A308D31319"));
        byte[] bytes = new byte[1024];
        DataOutputStream dos = new DataOutputStream(urlCon.getOutputStream());
        this.uploadSingleFile(path, dos, bytes, this.encoding);
        dos.writeBytes(String.format("\r\n--%s--\r\n", "----------------3243F6A8885A308D31319"));
        dos.close();
        String enc = urlCon.getContentEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        if (!(redirectURL = (br = new BufferedReader(new InputStreamReader(urlCon.getInputStream(), enc))).readLine()).equals("success")) {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                System.err.printf("%s%n", line);
            }
            throw new IOException(sb.toString());
        }
        br.close();
    }

    protected void uploadSingleFile(String path, DataOutputStream dos, byte[] bytes, String enc) throws IOException, FileNotFoundException {
        this.uploadSingleFile(path, "text/plain", dos, bytes, enc);
    }

    protected void uploadSingleFile(String path, String mimetype, DataOutputStream dos, byte[] bytes, String enc) throws IOException, FileNotFoundException {
        File f = new File(this.baseDir, path);
        if (!f.exists()) {
            return;
        }
        dos.writeBytes(String.format("\r\n--%s\r\n", "----------------3243F6A8885A308D31319"));
        dos.writeBytes(String.format("content-disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n", path, f.getCanonicalPath()));
        dos.writeBytes(String.format("Content-Type: %s\r\n\r\n", mimetype));
        if (enc == null) {
            int len;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            while ((len = bis.read(bytes, 0, 1024)) != -1) {
                dos.write(bytes, 0, len);
            }
            bis.close();
        } else {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), enc));
            while ((line = r.readLine()) != null) {
                line = String.format("%s\r\n", line);
                dos.write(line.getBytes(enc));
            }
            r.close();
        }
        dos.flush();
    }

    protected File saveContents(String path, String contents) throws IOException {
        this.content.put(path, contents);
        File f = new File(this.baseDir, path);
        OutputStreamWriter fw = this.encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.encoding) : new OutputStreamWriter(new FileOutputStream(f));
        fw.append(contents);
        fw.close();
        int i = 0;
        while (i < this.sources.length) {
            String n = this.sources[i];
            if (n.equals(path)) break;
            ++i;
        }
        if (i == this.sources.length) {
            String[] newSources = new String[this.sources.length + 1];
            int j = 0;
            while (j < this.sources.length) {
                newSources[j] = this.sources[j];
                ++j;
            }
            newSources[j] = path;
        }
        return f;
    }

    @Override
    public String save(String path, String contents) throws IOException {
        this.saveContents(path, contents);
        return null;
    }

    @Override
    public String save(HashMap<String, String> json) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String name : json.keySet()) {
            String content = json.get(name);
            if (content == null) continue;
            sb.append(this.save(name, content));
        }
        return sb.toString();
    }

    protected String delete(String path) {
        this.content.remove(path);
        File f = new File(this.baseDir, path);
        f.delete();
        int i = 0;
        while (i < this.sources.length) {
            String name = this.sources[i];
            if (name.equals(path)) break;
            ++i;
        }
        if (i < this.sources.length) {
            String[] newSources = new String[this.sources.length - 1];
            int j = 0;
            while (j < i) {
                newSources[j] = this.sources[j];
                ++j;
            }
            j = i + 1;
            while (j < this.sources.length) {
                newSources[j] = this.sources[j + 1];
                ++j;
            }
            this.sources = newSources;
        }
        return "{}";
    }

    protected String rename(String path1, String path2) {
        String c = this.content.remove(path1);
        this.content.put(path2, c);
        File f = new File(this.baseDir, path1);
        File g = new File(this.baseDir, path2);
        f.renameTo(g);
        int i = 0;
        while (i < this.sources.length) {
            String name = this.sources[i];
            if (name.equals(path1)) {
                this.sources[i] = path2;
                break;
            }
            ++i;
        }
        return "{}";
    }

    @Override
    public boolean start(String account, String passwd) throws IOException {
        return true;
    }

    @Override
    public boolean stop() throws IOException {
        return true;
    }

    @Override
    public int run(String[] args) throws IOException {
        return 0;
    }

    @Override
    public Process exec(String[] args) throws IOException {
        return null;
    }

    @Override
    public void view(String path, OutputStream out) throws IOException {
        int len;
        File f = new File(this.baseDir, path);
        FileInputStream in = new FileInputStream(f);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    @Override
    public void view(Appendable out) throws IOException {
        int bufSize = 1536;
        byte[] tmp = new byte[bufSize];
        String sep = "  ";
        out.append("{\r\n");
        String[] stringArray = this.targets;
        int n = this.targets.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File f = new File(this.baseDir, path);
            if (f.exists()) {
                int n3;
                out.append(sep);
                out.append("\"");
                out.append(path);
                out.append("\": ");
                FileInputStream is = new FileInputStream(new File(this.baseDir, path));
                String plus = "";
                while ((n3 = ((InputStream)is).read(tmp)) > 0) {
                    if (n3 != bufSize) {
                        int size = n3;
                        switch (n3 % 3) {
                            case 1: {
                                ++size;
                                tmp[n3 + 1] = 0;
                            }
                            case 2: {
                                ++size;
                                tmp[n3] = 0;
                            }
                        }
                        byte[] copy = new byte[size];
                        System.arraycopy(tmp, 0, copy, 0, size);
                        out.append(plus);
                        JSON.escapeScript((Object)copy, (Appendable)out);
                        break;
                    }
                    out.append(plus);
                    JSON.escapeScript((Object)tmp, (Appendable)out);
                    plus = "+";
                }
                ((InputStream)is).close();
                if (plus.equals("")) {
                    out.append("\"\"");
                }
                out.append("\r\n");
                sep = ", ";
            }
            ++n2;
        }
        out.append("}\r\n");
    }

    @Override
    public String view() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.view(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForLoad() throws IOException {
        try {
            HashMap<String, String> hashMap = this.content;
            synchronized (hashMap) {
                while (!this.contentChanged) {
                    this.content.wait();
                }
                this.contentChanged = false;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contentChangeNotify() {
        this.contentChanged = true;
        HashMap<String, String> hashMap = this.content;
        synchronized (hashMap) {
            this.content.notify();
        }
    }

    @Override
    public boolean waitForRead() throws IOException {
        return this.waitForRead(0);
    }

    @Override
    public boolean waitForRead(int index) throws IOException {
        return false;
    }

    @Override
    public HashMap<String, Object> getStatus() {
        return this.status;
    }

    @Override
    public boolean isAuthenticationNecessary() {
        return false;
    }

    @Override
    public String send(HashMap<String, Object> json) throws IOException {
        ArrayList ren;
        Object param = json.get("save");
        if (param != null) {
            return this.save((HashMap)param);
        }
        Object path = json.get("delete");
        if (path != null) {
            return this.delete((String)path);
        }
        Object ren0 = json.get("rename");
        if (ren0 != null && (ren = (ArrayList)ren0).size() > 1) {
            return this.rename((String)ren.get(0), (String)ren.get(1));
        }
        String abort = (String)json.get("abort");
        if (abort != null && (abort.equalsIgnoreCase("true") || abort.equalsIgnoreCase("yes"))) {
            return this.abort();
        }
        String eof = (String)json.get("eof");
        if (eof != null && (eof.equalsIgnoreCase("true") || eof.equalsIgnoreCase("yes"))) {
            return this.eof();
        }
        Object message = json.get("message");
        if (message != null) {
            return this.write(String.format("%s%n", (String)message));
        }
        return "{}";
    }

    public static IContext getCurrentContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        int contextId = -1;
        try {
            contextId = Integer.parseInt(request.getParameter("contextId"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (contextId == -1) {
            try {
                contextId = (Integer)request.getAttribute("contextId");
            }
            catch (Throwable e) {
                contextId = 0;
            }
        }
        ArrayList contextList = (ArrayList)session.getAttribute("contextList");
        IContext context = (IContext)contextList.get(contextId);
        return context;
    }
}

