/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ContextBuffer {
    public static final String LENGTH = "length";
    public static final String INDEX = "index";
    public static final String SERIAL = "serial";
    public static final String KIND = "kind";
    public static final String OUTPUT = "output";
    private List<HashMap<String, Object>> buf = new ArrayList<HashMap<String, Object>>();
    private boolean threadSuspended = true;
    private int currentSerial = 0;
    private int currentIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, Object> newStatusPacket(String k, Object v) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(KIND, k);
        ret.put(k, v);
        ContextBuffer contextBuffer = this;
        synchronized (contextBuffer) {
            ret.put(SERIAL, this.currentSerial++);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, Object> newMessagePacket(String k, String v) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int len = v.length();
        ret.put(KIND, k);
        ret.put(OUTPUT, v);
        ContextBuffer contextBuffer = this;
        synchronized (contextBuffer) {
            ret.put(INDEX, this.currentIndex);
            this.currentIndex += len;
            ret.put(SERIAL, this.currentSerial++);
        }
        ret.put(LENGTH, len);
        return ret;
    }

    ArrayList<HashMap<String, Object>> toJSONArrayWithIndex(int index) {
        return this.toJSONArrayWithIndex(index, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<HashMap<String, Object>> toJSONArrayWithIndex(int index, int length) {
        ArrayList<HashMap<String, Object>> sb = new ArrayList<HashMap<String, Object>>();
        ContextBuffer contextBuffer = this;
        synchronized (contextBuffer) {
            Integer idx;
            HashMap<String, Object> o;
            int i = 0;
            while (i < this.buf.size()) {
                o = this.buf.get(i);
                idx = (Integer)o.get(INDEX);
                if (idx == null) {
                    sb.add(o);
                } else {
                    Integer len = (Integer)o.get(LENGTH);
                    if (idx + len > index) break;
                }
                ++i;
            }
            while (i < this.buf.size()) {
                o = this.buf.get(i);
                idx = (Integer)o.get(INDEX);
                if (idx != null && length >= 0 && idx >= index + length) break;
                sb.add(o);
                ++i;
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<HashMap<String, Object>> toJSONArray(int begin) {
        ArrayList<HashMap<String, Object>> sb = new ArrayList<HashMap<String, Object>>();
        ContextBuffer contextBuffer = this;
        synchronized (contextBuffer) {
            int i = begin;
            while (i < this.buf.size()) {
                sb.add(this.buf.get(i));
                ++i;
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<HashMap<String, Object>> toJSONArray(int begin, int num) {
        ArrayList<HashMap<String, Object>> sb = new ArrayList<HashMap<String, Object>>();
        ContextBuffer contextBuffer = this;
        synchronized (contextBuffer) {
            int i = begin;
            while (i < this.buf.size() && num > 0) {
                sb.add(this.buf.get(i));
                ++i;
                --num;
            }
        }
        return sb;
    }

    ArrayList<HashMap<String, Object>> toJSONArray() {
        return this.toJSONArray(0);
    }

    static String escapeString(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\u000b': {
                    sb.append("\\v");
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        sb.append(String.format("\\x%02X", c));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++n2;
        }
        sb.append("\"");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPacket(HashMap<String, Object> newPair) {
        ContextBuffer contextBuffer = this;
        synchronized (contextBuffer) {
            this.buf.add(newPair);
            this.threadSuspended = false;
            this.notifyAll();
        }
    }

    void waitForInput() {
        this.waitForInput(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitForInput(int index) {
        var2_2 = this;
        synchronized (var2_2) {
            while (true) {
                if (index < this.currentIndex) {
                    return;
                }
                if (true) ** GOTO lbl12
                break;
            }
            {
                do {
                    this.wait();
lbl12:
                    // 2 sources

                } while (this.threadSuspended);
                this.threadSuspended = true;
                ** continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitForPacket(int serial) {
        var2_2 = this;
        synchronized (var2_2) {
            while (true) {
                if (serial < this.currentSerial) {
                    return;
                }
                if (true) ** GOTO lbl12
                break;
            }
            {
                do {
                    this.wait();
lbl12:
                    // 2 sources

                } while (this.threadSuspended);
                this.threadSuspended = true;
                ** continue;
            }
        }
    }
}

