/*
 * Decompiled with CFR 0.152.
 */
package applets;

import check.CheckURI;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import netscape.javascript.JSObject;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class Main
extends JApplet {
    private static final long serialVersionUID = 1L;
    private static final String contextName = "WappenLite";
    private Server server;

    @Override
    public void init() {
        JButton stop;
        block12: {
            TypeUtil.convertHexDigit((byte)48);
            this.setLayout(new FlowLayout());
            stop = new JButton("stop");
            final JTextArea error = new JTextArea(20, 80);
            JScrollPane scroll = new JScrollPane(error);
            this.add(stop);
            this.add(scroll);
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    error.append(new String(new byte[]{(byte)b}));
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    error.append(new String(b, off, len));
                }
            }){

                @Override
                public PrintStream append(char c) {
                    error.append(new String(new char[]{c}));
                    return this;
                }

                @Override
                public PrintStream append(CharSequence csq) {
                    error.append(csq.toString());
                    return this;
                }

                @Override
                public PrintStream append(CharSequence csq, int start, int end) {
                    error.append(csq.subSequence(start, end).toString());
                    return this;
                }
            });
            URL baseURL = this.getDocumentBase();
            try {
                if (!CheckURI.checkURI(baseURL.toURI())) {
                    System.err.printf("invalid document base URL %s%n", baseURL);
                    System.err.printf("applets.Main#init failure.%n", new Object[0]);
                    return;
                }
            }
            catch (URISyntaxException e2) {
                e2.printStackTrace(System.err);
                System.err.printf("applets.Main#init failure.%n", new Object[0]);
                return;
            }
            try {
                String config = this.getParameter("wappen.config");
                if (config != null) {
                    config = new URL(baseURL, config).toExternalForm();
                }
                String json = this.getParameter("wappen.json");
                System.err.printf("Json: %s%n", json);
                String war = this.getParameter("wappen.war");
                String start = this.getParameter("wappen.start");
                String target = this.getParameter("wappen.target");
                String eval = this.getParameter("wappen.eval");
                String port = this.getParameter("wappen.port");
                int portN = 0;
                if (port != null) {
                    try {
                        portN = Integer.parseInt(port);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (war != null) {
                    if ((war = new URL(baseURL, war).toExternalForm()).endsWith(".war")) {
                        war = "jar:" + war + "!/";
                    }
                    this.startServer(war, config, json, start, target, eval, portN);
                    break block12;
                }
                String dir = this.getParameter("wappen.dir");
                if (dir != null) {
                    dir = new URL(baseURL, dir).toExternalForm();
                    this.startServer(dir, config, json, start, target, eval, portN);
                    break block12;
                }
                System.err.println("Either wappen.dir or wappen.war must be specified.");
                return;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
        }
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Main.this.server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void destroy() {
        System.out.println("destroy");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        TypeUtil.convertHexDigit((byte)48);
        String dir = args[0];
        if (dir.endsWith(".war")) {
            dir = "jar:" + dir + "!/";
        }
        int port = 0;
        try {
            port = Integer.parseInt(args[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Main().startServer(dir, args[1], null, args[2], null, null, port);
    }

    private void startServer(String url, String config, String json, String start, String target, String eval, int port) throws IOException {
        block14: {
            WebAppContext web;
            block13: {
                Resource resource;
                try {
                    resource = Resource.newResource((String)url);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                SelectChannelConnector connector = null;
                connector = new SelectChannelConnector();
                connector.setPort(port);
                this.server = new Server();
                this.server.setConnectors(new Connector[]{connector});
                web = new WebAppContext();
                web.setBaseResource(resource);
                web.setContextPath(String.format("/%s", contextName));
                try {
                    if (config != null) {
                        web.getServletContext().setInitParameter("config", config);
                        break block13;
                    }
                    if (json != null) {
                        web.getServletContext().setInitParameter("json", json);
                        web.getServletContext().setInitParameter("documentBase", this.getDocumentBase().toExternalForm());
                        break block13;
                    }
                    System.err.println("Either wappen.config or wappen.json must be specified.");
                    return;
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    System.err.println(web.getServletContext().toString());
                    System.exit(1);
                }
            }
            web.setConfigurationClasses(new String[]{"org.eclipse.jetty.webapp.WebXmlConfiguration"});
            this.server.setHandler((Handler)web);
            try {
                this.server.start();
                Connector currentConnector = this.server.getConnectors()[0];
                port = currentConnector.getLocalPort();
                String urlStr = String.format("http://127.0.0.1:%d/%s/", port, contextName);
                if (eval != null) {
                    JSObject window = JSObject.getWindow((Applet)this);
                    window.eval(String.format(eval, urlStr));
                    break block14;
                }
                String callStr = urlStr;
                if (start != null) {
                    callStr = String.format(start, urlStr);
                }
                System.out.println(callStr);
                try {
                    AppletContext appContext = this.getAppletContext();
                    System.err.printf("myURL = %s%n", urlStr);
                    if (target != null) {
                        appContext.showDocument(new URL(this.getDocumentBase(), callStr), target);
                        break block14;
                    }
                    appContext.showDocument(new URL(this.getDocumentBase(), callStr), "_blank");
                }
                catch (NullPointerException e) {
                    Desktop.getDesktop().browse(new URI(callStr));
                }
            }
            catch (Exception e) {
                System.err.println("server failed to start:");
                e.printStackTrace(System.err);
            }
        }
    }
}

