/*
 * Decompiled with CFR 0.152.
 */
package filters;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.JSON;
import util.IContext;

public class AuthFilter
implements Filter {
    private String konfig;
    private String json;
    private String documentBase;
    private ServletContext scontext;

    private static IContext getContextInstance(HashMap<String, String> env, String myClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        IContext context = null;
        if (myClass != null) {
            System.err.printf("AuthFilter#getContextInstance: %s%n", myClass);
            Class<?> c = Class.forName(myClass);
            Constructor<?> cons = c.getConstructor(new Class[0]);
            context = (IContext)cons.newInstance(new Object[0]);
            context.configure(env);
            return context;
        }
        System.err.println("AuthFilter: context instantiation failure. (class==null)");
        return context;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        this.scontext = fConfig.getServletContext();
        this.konfig = this.scontext.getInitParameter("config");
        this.json = this.scontext.getInitParameter("json");
        this.documentBase = this.scontext.getInitParameter("documentBase");
    }

    public void destroy() {
        IContext context = (IContext)this.scontext.getAttribute("context");
        if (context != null) {
            try {
                context.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private IContext setContext(HttpServletRequest request) throws Exception {
        String config = request.getParameter("wappen.config");
        if (config == null) {
            config = this.konfig;
        }
        IContext context = AuthFilter.createContext(request, config, this.json, this.documentBase);
        this.scontext.setAttribute("context", (Object)context);
        this.scontext.setAttribute("index", (Object)0);
        return context;
    }

    public static IContext createContext(HttpServletRequest request, String config, String jsonStr, String documentBase) throws Exception {
        String requestURL = request.getRequestURL().toString();
        HashMap env = null;
        System.err.printf("AuthFilter#setContext: URL=%s%n", requestURL);
        System.err.printf("AuthFilter#setContext:: config=%s%n", config);
        if (config != null) {
            try {
                URL configURL = new URL(new URL(requestURL), config);
                InputStreamReader rd = new InputStreamReader(configURL.openStream(), "UTF-8");
                env = (HashMap)JSON.decode((Reader)rd);
                ((Reader)rd).close();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (jsonStr != null) {
            env = (HashMap)JSON.decode((String)jsonStr);
        }
        if (env == null) {
            System.err.println("Usually, either config or json must be specified.");
            env = new HashMap();
        }
        System.err.printf("AuthFilter#setContext: env=%s%n", env);
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("wappen.")) continue;
            String value = request.getParameter(name);
            name = name.substring("wappen.".length());
            env.put(name, value);
        }
        String baseURLString = (String)env.get("baseURL");
        if (baseURLString == null) {
            if (config != null) {
                try {
                    if (config != null) {
                        env.put("baseURL", new URL(new URL(requestURL), config).toExternalForm());
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                env.put("baseURL", documentBase);
            }
        } else {
            try {
                new URL(baseURLString);
            }
            catch (MalformedURLException e) {
                baseURLString = new URL(new URL(documentBase), baseURLString).toExternalForm();
                env.put("baseURL", baseURLString);
            }
        }
        String myClass = (String)env.get("class");
        System.err.printf("AuthFilter#setContext: class=%s%n", myClass);
        if (myClass == null) {
            System.err.println("AuthFilter#setContext: class initialization failure. (class==null)");
        }
        IContext context = null;
        try {
            context = AuthFilter.getContextInstance(env, myClass);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        System.err.printf("AuthFilter#setContext: context=%s%n", context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req0, ServletResponse res0, FilterChain chain) throws IOException, ServletException {
        IContext context;
        HttpServletRequest request = (HttpServletRequest)req0;
        HttpServletResponse response = (HttpServletResponse)res0;
        String origin = request.getHeader("Origin");
        String method = request.getMethod();
        if (origin != null && method.equals("OPTIONS")) {
            chain.doFilter(req0, res0);
            return;
        }
        AuthFilter authFilter = this;
        synchronized (authFilter) {
            context = (IContext)this.scontext.getAttribute("context");
            if (context == null) {
                try {
                    context = this.setContext(request);
                }
                catch (Exception e) {
                    System.err.println("AuthFilter#doFilter: context initialization failure!");
                    response.sendError(500, "<span style='color:red'>context initialization failure!</span>");
                    return;
                }
            }
            if (context == null) {
                System.err.println("AuthFilter#doFilter: context initialization failure!");
                response.sendError(500, "<span style='color:red'>context initialization failure!</span>");
                return;
            }
        }
        authFilter = this;
        synchronized (authFilter) {
            String account = (String)this.scontext.getAttribute("account");
            if (account == null) {
                boolean needAuthentication = context.isAuthenticationNecessary();
                if (needAuthentication) {
                    response.sendError(401, "<span style='color:red'>need authentication.</span>");
                    return;
                }
                account = "anonymous";
                if (context.start(account, "")) {
                    this.scontext.setAttribute("account", (Object)account);
                }
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    static String originalURL(HttpServletRequest request) {
        StringBuffer originalURL = request.getRequestURL();
        String qs = request.getQueryString();
        if (qs != null && !qs.equals("")) {
            qs = qs.replace("&", "%26");
            qs = qs.replace("=", "%3d");
            originalURL.append("?");
            originalURL.append(qs);
        }
        return originalURL.toString();
    }
}

