/*
 * Decompiled with CFR 0.152.
 */
package servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.arnx.jsonic.JSON;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import util.IConnection;
import util.IContext;

public class Connect
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    private ServletContext scontext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.scontext = config.getServletContext();
    }

    public WebSocket doWebSocketConnect(final HttpServletRequest request, String protocol) {
        String myName = this.getServletName();
        Connect.checkOrigin(request, myName);
        return new WebSocket(){
            IConnection out;

            public void onConnect(final WebSocket.Outbound outb) {
                IContext context = (IContext)Connect.this.scontext.getAttribute("context");
                this.out = new IConnection(){
                    private String str = "";

                    @Override
                    public void send(ArrayList<HashMap<String, Object>> json) throws IOException {
                        String tmp = String.valueOf(JSON.encode(json)) + "\r\n";
                        if (outb.isOpen()) {
                            outb.sendMessage(String.valueOf(this.str) + tmp);
                            this.str = "";
                        } else {
                            this.str = String.valueOf(this.str) + tmp;
                        }
                    }

                    @Override
                    public void send(HashMap<String, Object> json) throws IOException {
                        ArrayList<HashMap<String, Object>> sent = new ArrayList<HashMap<String, Object>>();
                        sent.add(json);
                        this.send(sent);
                    }

                    @Override
                    public void close() throws IOException {
                        if (outb.isOpen()) {
                            if (this.str.length() > 0) {
                                outb.sendMessage(this.str);
                            }
                            outb.disconnect();
                        }
                    }

                    @Override
                    public boolean isOpen() {
                        return outb.isOpen();
                    }
                };
                context.connect(this.out);
            }

            public void onDisconnect() {
                IContext context = (IContext)Connect.this.scontext.getAttribute("context");
                context.disconnect(this.out);
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void onMessage(byte arg0, String message) {
                String args;
                String pIndex;
                IContext context = (IContext)Connect.this.scontext.getAttribute("context");
                HashMap json = (HashMap)JSON.decode((String)message);
                String input = (String)json.get("write#message");
                if (input != null) {
                    try {
                        context.write(String.format("%s%n", input));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((pIndex = (String)json.get("read#index")) != null) {
                    String pReset = json != null ? (String)json.get("read#reset") : null;
                    boolean reset = pReset != null && pReset.equalsIgnoreCase("true");
                    try {
                        int index = Integer.parseInt(pIndex);
                        if (reset) {
                            context.reset();
                        }
                        ArrayList<HashMap<String, Object>> content = context.read(index);
                        this.out.send(content);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((args = request.getParameter("run#args")) != null) {
                    try {
                        context.run(args.split("\\s+"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            public void onMessage(byte arg0, byte[] arg1, int arg2, int arg3) {
            }
        };
    }

    static void checkOrigin(HttpServletRequest request, String myName) {
        String origin = request.getHeader("Sec-WebSocket-Origin");
        if (origin == null) {
            System.err.printf("%s: Sec-WebSocket-Origin is null\r\n", myName);
        }
    }
}

