/*
 * Decompiled with CFR 0.152.
 */
package servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import util.IContext;

public class View
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ServletContext scontext;

    public void init(ServletConfig config) throws ServletException {
        this.scontext = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getParameter("path");
        if (!this.safePath(path)) {
            System.err.printf("Invalid path %s%n", path);
            response.sendError(403, "Invalid path");
            return;
        }
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(path);
        response.setContentType(type);
        IContext context = (IContext)this.scontext.getAttribute("context");
        ServletOutputStream out = response.getOutputStream();
        context.view(path, (OutputStream)out);
    }

    private boolean safePath(String path) {
        String[] dirs;
        if (path.startsWith("/") || path.startsWith("\\")) {
            return false;
        }
        String[] stringArray = dirs = path.split("/|\\\\");
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            if (dir.equals("..")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

