/*
 * Decompiled with CFR 0.152.
 */
package applets;

import applets.JTextAreaStream;
import check.CheckURI;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import netscape.javascript.JSObject;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import util.SocketPolicyServer;

public class Main
extends JApplet {
    private static final long serialVersionUID = 1L;
    private static final String contextName = "WappenLite";
    private Server server;

    @Override
    public void init() {
        JButton stop;
        block12: {
            TypeUtil.convertHexDigit((byte)48);
            this.setLayout(new FlowLayout());
            stop = new JButton("stop");
            JTextArea error = new JTextArea(20, 80);
            JScrollPane scroll = new JScrollPane(error);
            this.add(stop);
            this.add(scroll);
            System.setOut(new JTextAreaStream(error));
            System.setErr(new JTextAreaStream(error));
            URL baseURL = this.getDocumentBase();
            try {
                if (!CheckURI.checkURI(baseURL.toURI())) {
                    System.err.printf("invalid document base URL %s. Please read the WappenLite document and see check/CheckURI.java.%n", baseURL);
                    System.err.printf("applets.Main#init failure.%n", new Object[0]);
                    return;
                }
            }
            catch (URISyntaxException e2) {
                e2.printStackTrace(System.err);
                System.err.printf("applets.Main#init failure.%n", new Object[0]);
                return;
            }
            try {
                String config = this.getParameter("wappen.config");
                if (config != null) {
                    config = new URL(baseURL, config).toExternalForm();
                }
                String json = this.getParameter("wappen.json");
                String war = this.getParameter("wappen.war");
                String start = this.getParameter("wappen.start");
                String target = this.getParameter("wappen.target");
                String eval = this.getParameter("wappen.eval");
                String port = this.getParameter("wappen.port");
                int portN = 0;
                if (port != null) {
                    try {
                        portN = Integer.parseInt(port);
                    }
                    catch (NumberFormatException e) {
                        System.err.printf("wappen.port is specified but cannot be parsed (ignored): %s%n", port);
                    }
                }
                if (war != null) {
                    if ((war = new URL(baseURL, war).toExternalForm()).endsWith(".war")) {
                        war = "jar:" + war + "!/";
                    }
                    this.startServer(war, config, json, start, target, eval, "127.0.0.1", portN, true);
                    break block12;
                }
                String dir = this.getParameter("wappen.dir");
                if (dir != null) {
                    dir = new URL(baseURL, dir).toExternalForm();
                    this.startServer(dir, config, json, start, target, eval, "127.0.0.1", portN, true);
                    break block12;
                }
                System.err.println("Either wappen.dir or wappen.war must be specified.");
                return;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
        }
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Main.this.server.stop();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    System.err.printf("could not stop server for some reason!%n", new Object[0]);
                }
            }
        });
    }

    @Override
    public void destroy() {
        System.out.println("destroy");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.printf("could not stop server for some reason!%n", new Object[0]);
        }
    }

    public static void main(String[] args) throws IOException {
        String config;
        String dir;
        TypeUtil.convertHexDigit((byte)48);
        int argslen = args.length;
        if (argslen <= 0) {
            System.err.printf("main: at least one command line argument must be specified.", new Object[0]);
            System.exit(1);
        }
        if ((dir = args[0]).endsWith(".war")) {
            dir = "jar:" + dir + "!/";
        }
        String string = config = argslen > 1 ? args[1] : null;
        if (config != null && config.equals("-")) {
            config = null;
        }
        String start = argslen > 2 ? args[2] : null;
        int port = 0;
        try {
            port = Integer.parseInt(args[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean forcePolicy = argslen > 4 && (args[4].equalsIgnoreCase("true") || args[3].equalsIgnoreCase("yes"));
        String host = argslen > 5 ? args[5] : InetAddress.getLocalHost().getHostName();
        new Main().startServer(dir, config, null, start, null, null, host, port, forcePolicy);
    }

    private void startServer(String url, String config, String json, String start, String target, String eval, String host, int port, boolean forcePolicy) throws IOException {
        block16: {
            Resource resource;
            System.err.printf("startServer: url = %s, port = %d.%n", url, port);
            try {
                resource = Resource.newResource((String)url);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return;
            }
            if (!resource.exists()) {
                System.err.printf("resource (%s) does not exist, exitting ...%n", url);
                return;
            }
            SelectChannelConnector connector = null;
            connector = new SelectChannelConnector();
            connector.setPort(port);
            this.server = new Server();
            this.server.setConnectors(new Connector[]{connector});
            WebAppContext web = new WebAppContext();
            web.setBaseResource(resource);
            web.setContextPath(String.format("/%s", contextName));
            try {
                if (config != null) {
                    web.getServletContext().setInitParameter("config", config);
                } else if (json != null) {
                    web.getServletContext().setInitParameter("json", json);
                    URL documentBase = this.getDocumentBase();
                    if (documentBase != null) {
                        web.getServletContext().setInitParameter("documentBase", documentBase.toExternalForm());
                    }
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                System.err.println(web.getServletContext().toString());
                System.exit(1);
            }
            web.setConfigurationClasses(new String[]{"org.eclipse.jetty.webapp.WebXmlConfiguration"});
            this.server.setHandler((Handler)web);
            try {
                this.server.start();
                Connector currentConnector = this.server.getConnectors()[0];
                int realPort = currentConnector.getLocalPort();
                if (port == 0 && forcePolicy) {
                    SocketPolicyServer policyServer = new SocketPolicyServer(realPort);
                    policyServer.start();
                }
                String urlStr = String.format("http://%s:%d/%s/", host, realPort, contextName);
                if (eval != null) {
                    JSObject window = JSObject.getWindow((Applet)this);
                    window.eval(String.format(eval, urlStr));
                    break block16;
                }
                if (start == null) break block16;
                String callStr = urlStr;
                callStr = String.format(start, urlStr);
                System.err.println(callStr);
                try {
                    AppletContext appContext = this.getAppletContext();
                    System.err.printf("myURL = %s%n", urlStr);
                    if (target != null) {
                        appContext.showDocument(new URL(this.getDocumentBase(), callStr), target);
                        break block16;
                    }
                    appContext.showDocument(new URL(this.getDocumentBase(), callStr), "_blank");
                }
                catch (NullPointerException e) {
                    Desktop.getDesktop().browse(new URI(callStr));
                }
            }
            catch (Exception e) {
                System.err.println("server failed to start:");
                e.printStackTrace(System.err);
            }
        }
    }
}

