/*
 * Decompiled with CFR 0.152.
 */
package servlets;

import filters.AuthFilter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import util.IContext;

public class Login
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ServletContext scontext;

    public void init(ServletConfig config) throws ServletException {
        this.scontext = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IContext context;
        response.setContentType("text/html; charset=utf-8");
        HttpSession session = request.getSession();
        String account = request.getParameter("account");
        String passwd = request.getParameter("passwd");
        String url = request.getParameter("url");
        String referer = request.getParameter("referer");
        System.err.printf("Login#doPost: account = %s%n", account);
        if (url != null) {
            System.err.printf("Login#doPost: url = %s%n", url);
        }
        if ((context = (IContext)session.getAttribute("context")) == null) {
            try {
                context = AuthFilter.setContext(this.scontext, session, request);
            }
            catch (Exception e) {
                System.err.println("Login#doPost: setContext() failed.%n");
                response.sendError(500, e.getMessage());
                return;
            }
        }
        if (context == null) {
            System.err.println("Login: context initialization failure!");
            response.sendError(400, "<span style='color:red'>context initialization failure!</span>");
            return;
        }
        if (account != null) {
            if (!this.setAcccount(response, session, context, account, passwd)) {
                return;
            }
        } else {
            AuthFilter.setAccount(response, session, context);
        }
        if (url != null) {
            String urlX = url.replace("%26", "&").replace("%3d", "=");
            if (referer != null) {
                urlX = urlX.lastIndexOf(63) >= 0 ? String.valueOf(urlX) + "&referer=" + referer : String.valueOf(urlX) + "?referer=" + referer;
            }
            response.sendRedirect(response.encodeRedirectURL(urlX));
            return;
        }
        response.setContentType("text/plain; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.println("{}");
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setAcccount(HttpServletResponse response, HttpSession session, IContext context, String account, String passwd) throws IOException {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            String account0 = (String)session.getAttribute("account");
            if (account0 != null && account0 == account) {
                return true;
            }
            try {
                if (context.start(account, passwd)) {
                    session.setAttribute("account", (Object)account);
                    return true;
                }
            }
            catch (IOException e) {
                System.err.println("Login#doPost: IOExeption " + e.getMessage());
                e.printStackTrace();
            }
            System.err.println("Invalid Login/Password");
            response.sendError(403, "Invalid Login/Password");
            return false;
        }
    }
}

