/*
 * Decompiled with CFR 0.152.
 */
package servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import util.IContext;

public class View
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        String path = request.getParameter("path");
        if (!this.safePath(path)) {
            System.err.printf("Invalid path %s%n", path);
            response.sendError(403, "Invalid path");
            return;
        }
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(path);
        response.setContentType(type);
        IContext context = (IContext)session.getAttribute("context");
        if (context == null) {
            System.err.println("Save: context initialization failure!");
            response.sendError(400, "<span style='color:red'>Context not ready.</span>");
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        context.view(path, (OutputStream)out);
    }

    private boolean safePath(String path) {
        String[] dirs;
        if (path.startsWith("/") || path.startsWith("\\")) {
            return false;
        }
        String[] stringArray = dirs = path.split("/|\\\\");
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            if (dir.equals("..")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

